/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddonVersionsRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DescribeAddonVersionsRequest> {
    private static final SdkField<String> KUBERNETES_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kubernetesVersion").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::kubernetesVersion)).setter(DescribeAddonVersionsRequest.setter(Builder::kubernetesVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("kubernetesVersion").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::maxResults)).setter(DescribeAddonVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::nextToken)).setter(DescribeAddonVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::addonName)).setter(DescribeAddonVersionsRequest.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("addonName").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::types)).setter(DescribeAddonVersionsRequest.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PUBLISHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("publishers").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::publishers)).setter(DescribeAddonVersionsRequest.setter(Builder::publishers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("publishers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("owners").getter(DescribeAddonVersionsRequest.getter(DescribeAddonVersionsRequest::owners)).setter(DescribeAddonVersionsRequest.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("owners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KUBERNETES_VERSION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ADDON_NAME_FIELD, TYPES_FIELD, PUBLISHERS_FIELD, OWNERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAddonVersionsRequest.memberNameToFieldInitializer();
    private final String kubernetesVersion;
    private final Integer maxResults;
    private final String nextToken;
    private final String addonName;
    private final List<String> types;
    private final List<String> publishers;
    private final List<String> owners;

    private DescribeAddonVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.kubernetesVersion = builder.kubernetesVersion;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.addonName = builder.addonName;
        this.types = builder.types;
        this.publishers = builder.publishers;
        this.owners = builder.owners;
    }

    public final String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public final boolean hasPublishers() {
        return this.publishers != null && !(this.publishers instanceof SdkAutoConstructList);
    }

    public final List<String> publishers() {
        return this.publishers;
    }

    public final boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public final List<String> owners() {
        return this.owners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublishers() ? this.publishers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOwners() ? this.owners() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddonVersionsRequest)) {
            return false;
        }
        DescribeAddonVersionsRequest other = (DescribeAddonVersionsRequest)((Object)obj);
        return Objects.equals(this.kubernetesVersion(), other.kubernetesVersion()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.addonName(), other.addonName()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && this.hasPublishers() == other.hasPublishers() && Objects.equals(this.publishers(), other.publishers()) && this.hasOwners() == other.hasOwners() && Objects.equals(this.owners(), other.owners());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAddonVersionsRequest").add("KubernetesVersion", (Object)this.kubernetesVersion()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("AddonName", (Object)this.addonName()).add("Types", this.hasTypes() ? this.types() : null).add("Publishers", this.hasPublishers() ? this.publishers() : null).add("Owners", this.hasOwners() ? this.owners() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kubernetesVersion": {
                return Optional.ofNullable(clazz.cast(this.kubernetesVersion()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "publishers": {
                return Optional.ofNullable(clazz.cast(this.publishers()));
            }
            case "owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("kubernetesVersion", KUBERNETES_VERSION_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("addonName", ADDON_NAME_FIELD);
        map.put("types", TYPES_FIELD);
        map.put("publishers", PUBLISHERS_FIELD);
        map.put("owners", OWNERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddonVersionsRequest, T> g) {
        return obj -> g.apply((DescribeAddonVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String kubernetesVersion;
        private Integer maxResults;
        private String nextToken;
        private String addonName;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private List<String> publishers = DefaultSdkAutoConstructList.getInstance();
        private List<String> owners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddonVersionsRequest model) {
            super(model);
            this.kubernetesVersion(model.kubernetesVersion);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.addonName(model.addonName);
            this.types(model.types);
            this.publishers(model.publishers);
            this.owners(model.owners);
        }

        public final String getKubernetesVersion() {
            return this.kubernetesVersion;
        }

        public final void setKubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
        }

        @Override
        public final Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = StringListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = StringListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final Collection<String> getPublishers() {
            if (this.publishers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publishers;
        }

        public final void setPublishers(Collection<String> publishers) {
            this.publishers = StringListCopier.copy(publishers);
        }

        @Override
        public final Builder publishers(Collection<String> publishers) {
            this.publishers = StringListCopier.copy(publishers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publishers(String ... publishers) {
            this.publishers(Arrays.asList(publishers));
            return this;
        }

        public final Collection<String> getOwners() {
            if (this.owners instanceof SdkAutoConstructList) {
                return null;
            }
            return this.owners;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = StringListCopier.copy(owners);
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = StringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAddonVersionsRequest build() {
            return new DescribeAddonVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAddonVersionsRequest> {
        public Builder kubernetesVersion(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder addonName(String var1);

        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);

        public Builder publishers(Collection<String> var1);

        public Builder publishers(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

