/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FargateProfileIssueCode {
    POD_EXECUTION_ROLE_ALREADY_IN_USE("PodExecutionRoleAlreadyInUse"),
    ACCESS_DENIED("AccessDenied"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    INTERNAL_FAILURE("InternalFailure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FargateProfileIssueCode> VALUE_MAP;
    private final String value;

    private FargateProfileIssueCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FargateProfileIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FargateProfileIssueCode> knownValues() {
        EnumSet<FargateProfileIssueCode> knownValues = EnumSet.allOf(FargateProfileIssueCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FargateProfileIssueCode.class, FargateProfileIssueCode::toString);
    }
}

