/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNodegroupVersionRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateNodegroupVersionRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::clusterName)).setter(UpdateNodegroupVersionRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodegroupName").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::nodegroupName)).setter(UpdateNodegroupVersionRequest.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::version)).setter(UpdateNodegroupVersionRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseVersion").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::releaseVersion)).setter(UpdateNodegroupVersionRequest.setter(Builder::releaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchTemplate").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::launchTemplate)).setter(UpdateNodegroupVersionRequest.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("force").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::force)).setter(UpdateNodegroupVersionRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateNodegroupVersionRequest.getter(UpdateNodegroupVersionRequest::clientRequestToken)).setter(UpdateNodegroupVersionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODEGROUP_NAME_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD, LAUNCH_TEMPLATE_FIELD, FORCE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateNodegroupVersionRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String nodegroupName;
    private final String version;
    private final String releaseVersion;
    private final LaunchTemplateSpecification launchTemplate;
    private final Boolean force;
    private final String clientRequestToken;

    private UpdateNodegroupVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
        this.launchTemplate = builder.launchTemplate;
        this.force = builder.force;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String nodegroupName() {
        return this.nodegroupName;
    }

    public final String version() {
        return this.version;
    }

    public final String releaseVersion() {
        return this.releaseVersion;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final Boolean force() {
        return this.force;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupVersionRequest)) {
            return false;
        }
        UpdateNodegroupVersionRequest other = (UpdateNodegroupVersionRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releaseVersion(), other.releaseVersion()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.force(), other.force()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNodegroupVersionRequest").add("ClusterName", (Object)this.clusterName()).add("NodegroupName", (Object)this.nodegroupName()).add("Version", (Object)this.version()).add("ReleaseVersion", (Object)this.releaseVersion()).add("LaunchTemplate", (Object)this.launchTemplate()).add("Force", (Object)this.force()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releaseVersion": {
                return Optional.ofNullable(clazz.cast(this.releaseVersion()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("nodegroupName", NODEGROUP_NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("releaseVersion", RELEASE_VERSION_FIELD);
        map.put("launchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("force", FORCE_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupVersionRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodegroupName;
        private String version;
        private String releaseVersion;
        private LaunchTemplateSpecification launchTemplate;
        private Boolean force;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupVersionRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodegroupName(model.nodegroupName);
            this.version(model.version);
            this.releaseVersion(model.releaseVersion);
            this.launchTemplate(model.launchTemplate);
            this.force(model.force);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Boolean getForce() {
            return this.force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupVersionRequest build() {
            return new UpdateNodegroupVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNodegroupVersionRequest> {
        public Builder clusterName(String var1);

        public Builder nodegroupName(String var1);

        public Builder version(String var1);

        public Builder releaseVersion(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder force(Boolean var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

