/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AddonPodIdentityConfiguration;
import software.amazon.awssdk.services.eks.model.AddonPodIdentityConfigurationListCopier;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddonConfigurationResponse
extends EksResponse
implements ToCopyableBuilder<Builder, DescribeAddonConfigurationResponse> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::addonName)).setter(DescribeAddonConfigurationResponse.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()}).build();
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonVersion").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::addonVersion)).setter(DescribeAddonConfigurationResponse.setter(Builder::addonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()}).build();
    private static final SdkField<String> CONFIGURATION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationSchema").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::configurationSchema)).setter(DescribeAddonConfigurationResponse.setter(Builder::configurationSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationSchema").build()}).build();
    private static final SdkField<List<AddonPodIdentityConfiguration>> POD_IDENTITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("podIdentityConfiguration").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::podIdentityConfiguration)).setter(DescribeAddonConfigurationResponse.setter(Builder::podIdentityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podIdentityConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddonPodIdentityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD, ADDON_VERSION_FIELD, CONFIGURATION_SCHEMA_FIELD, POD_IDENTITY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAddonConfigurationResponse.memberNameToFieldInitializer();
    private final String addonName;
    private final String addonVersion;
    private final String configurationSchema;
    private final List<AddonPodIdentityConfiguration> podIdentityConfiguration;

    private DescribeAddonConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
        this.configurationSchema = builder.configurationSchema;
        this.podIdentityConfiguration = builder.podIdentityConfiguration;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final String addonVersion() {
        return this.addonVersion;
    }

    public final String configurationSchema() {
        return this.configurationSchema;
    }

    public final boolean hasPodIdentityConfiguration() {
        return this.podIdentityConfiguration != null && !(this.podIdentityConfiguration instanceof SdkAutoConstructList);
    }

    public final List<AddonPodIdentityConfiguration> podIdentityConfiguration() {
        return this.podIdentityConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPodIdentityConfiguration() ? this.podIdentityConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddonConfigurationResponse)) {
            return false;
        }
        DescribeAddonConfigurationResponse other = (DescribeAddonConfigurationResponse)((Object)obj);
        return Objects.equals(this.addonName(), other.addonName()) && Objects.equals(this.addonVersion(), other.addonVersion()) && Objects.equals(this.configurationSchema(), other.configurationSchema()) && this.hasPodIdentityConfiguration() == other.hasPodIdentityConfiguration() && Objects.equals(this.podIdentityConfiguration(), other.podIdentityConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAddonConfigurationResponse").add("AddonName", (Object)this.addonName()).add("AddonVersion", (Object)this.addonVersion()).add("ConfigurationSchema", (Object)this.configurationSchema()).add("PodIdentityConfiguration", this.hasPodIdentityConfiguration() ? this.podIdentityConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "addonVersion": {
                return Optional.ofNullable(clazz.cast(this.addonVersion()));
            }
            case "configurationSchema": {
                return Optional.ofNullable(clazz.cast(this.configurationSchema()));
            }
            case "podIdentityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.podIdentityConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addonName", ADDON_NAME_FIELD);
        map.put("addonVersion", ADDON_VERSION_FIELD);
        map.put("configurationSchema", CONFIGURATION_SCHEMA_FIELD);
        map.put("podIdentityConfiguration", POD_IDENTITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddonConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAddonConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private String addonName;
        private String addonVersion;
        private String configurationSchema;
        private List<AddonPodIdentityConfiguration> podIdentityConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddonConfigurationResponse model) {
            super(model);
            this.addonName(model.addonName);
            this.addonVersion(model.addonVersion);
            this.configurationSchema(model.configurationSchema);
            this.podIdentityConfiguration(model.podIdentityConfiguration);
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonVersion() {
            return this.addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final String getConfigurationSchema() {
            return this.configurationSchema;
        }

        public final void setConfigurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
        }

        @Override
        public final Builder configurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
            return this;
        }

        public final List<AddonPodIdentityConfiguration.Builder> getPodIdentityConfiguration() {
            List<AddonPodIdentityConfiguration.Builder> result = AddonPodIdentityConfigurationListCopier.copyToBuilder(this.podIdentityConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPodIdentityConfiguration(Collection<AddonPodIdentityConfiguration.BuilderImpl> podIdentityConfiguration) {
            this.podIdentityConfiguration = AddonPodIdentityConfigurationListCopier.copyFromBuilder(podIdentityConfiguration);
        }

        @Override
        public final Builder podIdentityConfiguration(Collection<AddonPodIdentityConfiguration> podIdentityConfiguration) {
            this.podIdentityConfiguration = AddonPodIdentityConfigurationListCopier.copy(podIdentityConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder podIdentityConfiguration(AddonPodIdentityConfiguration ... podIdentityConfiguration) {
            this.podIdentityConfiguration(Arrays.asList(podIdentityConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder podIdentityConfiguration(Consumer<AddonPodIdentityConfiguration.Builder> ... podIdentityConfiguration) {
            this.podIdentityConfiguration(Stream.of(podIdentityConfiguration).map(c -> (AddonPodIdentityConfiguration)((AddonPodIdentityConfiguration.Builder)AddonPodIdentityConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAddonConfigurationResponse build() {
            return new DescribeAddonConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAddonConfigurationResponse> {
        public Builder addonName(String var1);

        public Builder addonVersion(String var1);

        public Builder configurationSchema(String var1);

        public Builder podIdentityConfiguration(Collection<AddonPodIdentityConfiguration> var1);

        public Builder podIdentityConfiguration(AddonPodIdentityConfiguration ... var1);

        public Builder podIdentityConfiguration(Consumer<AddonPodIdentityConfiguration.Builder> ... var1);
    }
}

