/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.AccessScope;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAccessPolicyRequest
extends EksRequest
implements ToCopyableBuilder<Builder, AssociateAccessPolicyRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(AssociateAccessPolicyRequest.getter(AssociateAccessPolicyRequest::clusterName)).setter(AssociateAccessPolicyRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(AssociateAccessPolicyRequest.getter(AssociateAccessPolicyRequest::principalArn)).setter(AssociateAccessPolicyRequest.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalArn").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(AssociateAccessPolicyRequest.getter(AssociateAccessPolicyRequest::policyArn)).setter(AssociateAccessPolicyRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<AccessScope> ACCESS_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessScope").getter(AssociateAccessPolicyRequest.getter(AssociateAccessPolicyRequest::accessScope)).setter(AssociateAccessPolicyRequest.setter(Builder::accessScope)).constructor(AccessScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, PRINCIPAL_ARN_FIELD, POLICY_ARN_FIELD, ACCESS_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateAccessPolicyRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String principalArn;
    private final String policyArn;
    private final AccessScope accessScope;

    private AssociateAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.policyArn = builder.policyArn;
        this.accessScope = builder.accessScope;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final AccessScope accessScope() {
        return this.accessScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAccessPolicyRequest)) {
            return false;
        }
        AssociateAccessPolicyRequest other = (AssociateAccessPolicyRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.accessScope(), other.accessScope());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAccessPolicyRequest").add("ClusterName", (Object)this.clusterName()).add("PrincipalArn", (Object)this.principalArn()).add("PolicyArn", (Object)this.policyArn()).add("AccessScope", (Object)this.accessScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "accessScope": {
                return Optional.ofNullable(clazz.cast(this.accessScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("accessScope", ACCESS_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAccessPolicyRequest, T> g) {
        return obj -> g.apply((AssociateAccessPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String principalArn;
        private String policyArn;
        private AccessScope accessScope;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAccessPolicyRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.principalArn(model.principalArn);
            this.policyArn(model.policyArn);
            this.accessScope(model.accessScope);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AccessScope.Builder getAccessScope() {
            return this.accessScope != null ? this.accessScope.toBuilder() : null;
        }

        public final void setAccessScope(AccessScope.BuilderImpl accessScope) {
            this.accessScope = accessScope != null ? accessScope.build() : null;
        }

        @Override
        public final Builder accessScope(AccessScope accessScope) {
            this.accessScope = accessScope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAccessPolicyRequest build() {
            return new AssociateAccessPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAccessPolicyRequest> {
        public Builder clusterName(String var1);

        public Builder principalArn(String var1);

        public Builder policyArn(String var1);

        public Builder accessScope(AccessScope var1);

        default public Builder accessScope(Consumer<AccessScope.Builder> accessScope) {
            return this.accessScope((AccessScope)((AccessScope.Builder)AccessScope.builder().applyMutation(accessScope)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

