/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddonPodIdentityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddonPodIdentityConfiguration> {
    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccount").getter(AddonPodIdentityConfiguration.getter(AddonPodIdentityConfiguration::serviceAccount)).setter(AddonPodIdentityConfiguration.setter(Builder::serviceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccount").build()}).build();
    private static final SdkField<List<String>> RECOMMENDED_MANAGED_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendedManagedPolicies").getter(AddonPodIdentityConfiguration.getter(AddonPodIdentityConfiguration::recommendedManagedPolicies)).setter(AddonPodIdentityConfiguration.setter(Builder::recommendedManagedPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedManagedPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_FIELD, RECOMMENDED_MANAGED_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddonPodIdentityConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceAccount;
    private final List<String> recommendedManagedPolicies;

    private AddonPodIdentityConfiguration(BuilderImpl builder) {
        this.serviceAccount = builder.serviceAccount;
        this.recommendedManagedPolicies = builder.recommendedManagedPolicies;
    }

    public final String serviceAccount() {
        return this.serviceAccount;
    }

    public final boolean hasRecommendedManagedPolicies() {
        return this.recommendedManagedPolicies != null && !(this.recommendedManagedPolicies instanceof SdkAutoConstructList);
    }

    public final List<String> recommendedManagedPolicies() {
        return this.recommendedManagedPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedManagedPolicies() ? this.recommendedManagedPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonPodIdentityConfiguration)) {
            return false;
        }
        AddonPodIdentityConfiguration other = (AddonPodIdentityConfiguration)obj;
        return Objects.equals(this.serviceAccount(), other.serviceAccount()) && this.hasRecommendedManagedPolicies() == other.hasRecommendedManagedPolicies() && Objects.equals(this.recommendedManagedPolicies(), other.recommendedManagedPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"AddonPodIdentityConfiguration").add("ServiceAccount", (Object)this.serviceAccount()).add("RecommendedManagedPolicies", this.hasRecommendedManagedPolicies() ? this.recommendedManagedPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceAccount": {
                return Optional.ofNullable(clazz.cast(this.serviceAccount()));
            }
            case "recommendedManagedPolicies": {
                return Optional.ofNullable(clazz.cast(this.recommendedManagedPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceAccount", SERVICE_ACCOUNT_FIELD);
        map.put("recommendedManagedPolicies", RECOMMENDED_MANAGED_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddonPodIdentityConfiguration, T> g) {
        return obj -> g.apply((AddonPodIdentityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccount;
        private List<String> recommendedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddonPodIdentityConfiguration model) {
            this.serviceAccount(model.serviceAccount);
            this.recommendedManagedPolicies(model.recommendedManagedPolicies);
        }

        public final String getServiceAccount() {
            return this.serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final Collection<String> getRecommendedManagedPolicies() {
            if (this.recommendedManagedPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendedManagedPolicies;
        }

        public final void setRecommendedManagedPolicies(Collection<String> recommendedManagedPolicies) {
            this.recommendedManagedPolicies = StringListCopier.copy(recommendedManagedPolicies);
        }

        @Override
        public final Builder recommendedManagedPolicies(Collection<String> recommendedManagedPolicies) {
            this.recommendedManagedPolicies = StringListCopier.copy(recommendedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedManagedPolicies(String ... recommendedManagedPolicies) {
            this.recommendedManagedPolicies(Arrays.asList(recommendedManagedPolicies));
            return this;
        }

        public AddonPodIdentityConfiguration build() {
            return new AddonPodIdentityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddonPodIdentityConfiguration> {
        public Builder serviceAccount(String var1);

        public Builder recommendedManagedPolicies(Collection<String> var1);

        public Builder recommendedManagedPolicies(String ... var1);
    }
}

