/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.AccessPolicy;
import software.amazon.awssdk.services.eks.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.eks.model.ListAccessPoliciesResponse;

public class ListAccessPoliciesIterable
implements SdkIterable<ListAccessPoliciesResponse> {
    private final EksClient client;
    private final ListAccessPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPoliciesIterable(EksClient client, ListAccessPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessPoliciesResponseFetcher();
    }

    public Iterator<ListAccessPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessPolicy> accessPolicies() {
        Function<ListAccessPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPolicies() != null) {
                return response.accessPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessPoliciesResponseFetcher
    implements SyncPageFetcher<ListAccessPoliciesResponse> {
        private ListAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPoliciesResponse nextPage(ListAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPoliciesIterable.this.client.listAccessPolicies(ListAccessPoliciesIterable.this.firstRequest);
            }
            return ListAccessPoliciesIterable.this.client.listAccessPolicies((ListAccessPoliciesRequest)((Object)ListAccessPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

