/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AccessConfigResponse;
import software.amazon.awssdk.services.eks.model.Certificate;
import software.amazon.awssdk.services.eks.model.ClusterHealth;
import software.amazon.awssdk.services.eks.model.ClusterStatus;
import software.amazon.awssdk.services.eks.model.ComputeConfigResponse;
import software.amazon.awssdk.services.eks.model.ConnectorConfigResponse;
import software.amazon.awssdk.services.eks.model.EncryptionConfig;
import software.amazon.awssdk.services.eks.model.EncryptionConfigListCopier;
import software.amazon.awssdk.services.eks.model.Identity;
import software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigResponse;
import software.amazon.awssdk.services.eks.model.Logging;
import software.amazon.awssdk.services.eks.model.OutpostConfigResponse;
import software.amazon.awssdk.services.eks.model.RemoteNetworkConfigResponse;
import software.amazon.awssdk.services.eks.model.StorageConfigResponse;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.services.eks.model.UpgradePolicyResponse;
import software.amazon.awssdk.services.eks.model.VpcConfigResponse;
import software.amazon.awssdk.services.eks.model.ZonalShiftConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Cluster.getter(Cluster::name)).setter(Cluster.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Cluster.getter(Cluster::arn)).setter(Cluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Cluster.getter(Cluster::createdAt)).setter(Cluster.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(Cluster.getter(Cluster::version)).setter(Cluster.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(Cluster.getter(Cluster::endpoint)).setter(Cluster.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Cluster.getter(Cluster::roleArn)).setter(Cluster.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<VpcConfigResponse> RESOURCES_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesVpcConfig").getter(Cluster.getter(Cluster::resourcesVpcConfig)).setter(Cluster.setter(Builder::resourcesVpcConfig)).constructor(VpcConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build()}).build();
    private static final SdkField<KubernetesNetworkConfigResponse> KUBERNETES_NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kubernetesNetworkConfig").getter(Cluster.getter(Cluster::kubernetesNetworkConfig)).setter(Cluster.setter(Builder::kubernetesNetworkConfig)).constructor(KubernetesNetworkConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNetworkConfig").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(Cluster.getter(Cluster::logging)).setter(Cluster.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<Identity> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identity").getter(Cluster.getter(Cluster::identity)).setter(Cluster.setter(Builder::identity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Cluster.getter(Cluster::statusAsString)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Certificate> CERTIFICATE_AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificateAuthority").getter(Cluster.getter(Cluster::certificateAuthority)).setter(Cluster.setter(Builder::certificateAuthority)).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthority").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(Cluster.getter(Cluster::clientRequestToken)).setter(Cluster.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(Cluster.getter(Cluster::platformVersion)).setter(Cluster.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Cluster.getter(Cluster::tags)).setter(Cluster.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<EncryptionConfig>> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("encryptionConfig").getter(Cluster.getter(Cluster::encryptionConfig)).setter(Cluster.setter(Builder::encryptionConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectorConfigResponse> CONNECTOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorConfig").getter(Cluster.getter(Cluster::connectorConfig)).setter(Cluster.setter(Builder::connectorConfig)).constructor(ConnectorConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfig").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Cluster.getter(Cluster::id)).setter(Cluster.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ClusterHealth> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("health").getter(Cluster.getter(Cluster::health)).setter(Cluster.setter(Builder::health)).constructor(ClusterHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<OutpostConfigResponse> OUTPOST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outpostConfig").getter(Cluster.getter(Cluster::outpostConfig)).setter(Cluster.setter(Builder::outpostConfig)).constructor(OutpostConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostConfig").build()}).build();
    private static final SdkField<AccessConfigResponse> ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessConfig").getter(Cluster.getter(Cluster::accessConfig)).setter(Cluster.setter(Builder::accessConfig)).constructor(AccessConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessConfig").build()}).build();
    private static final SdkField<UpgradePolicyResponse> UPGRADE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("upgradePolicy").getter(Cluster.getter(Cluster::upgradePolicy)).setter(Cluster.setter(Builder::upgradePolicy)).constructor(UpgradePolicyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upgradePolicy").build()}).build();
    private static final SdkField<ZonalShiftConfigResponse> ZONAL_SHIFT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("zonalShiftConfig").getter(Cluster.getter(Cluster::zonalShiftConfig)).setter(Cluster.setter(Builder::zonalShiftConfig)).constructor(ZonalShiftConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftConfig").build()}).build();
    private static final SdkField<RemoteNetworkConfigResponse> REMOTE_NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remoteNetworkConfig").getter(Cluster.getter(Cluster::remoteNetworkConfig)).setter(Cluster.setter(Builder::remoteNetworkConfig)).constructor(RemoteNetworkConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteNetworkConfig").build()}).build();
    private static final SdkField<ComputeConfigResponse> COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeConfig").getter(Cluster.getter(Cluster::computeConfig)).setter(Cluster.setter(Builder::computeConfig)).constructor(ComputeConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfig").build()}).build();
    private static final SdkField<StorageConfigResponse> STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageConfig").getter(Cluster.getter(Cluster::storageConfig)).setter(Cluster.setter(Builder::storageConfig)).constructor(StorageConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, VERSION_FIELD, ENDPOINT_FIELD, ROLE_ARN_FIELD, RESOURCES_VPC_CONFIG_FIELD, KUBERNETES_NETWORK_CONFIG_FIELD, LOGGING_FIELD, IDENTITY_FIELD, STATUS_FIELD, CERTIFICATE_AUTHORITY_FIELD, CLIENT_REQUEST_TOKEN_FIELD, PLATFORM_VERSION_FIELD, TAGS_FIELD, ENCRYPTION_CONFIG_FIELD, CONNECTOR_CONFIG_FIELD, ID_FIELD, HEALTH_FIELD, OUTPOST_CONFIG_FIELD, ACCESS_CONFIG_FIELD, UPGRADE_POLICY_FIELD, ZONAL_SHIFT_CONFIG_FIELD, REMOTE_NETWORK_CONFIG_FIELD, COMPUTE_CONFIG_FIELD, STORAGE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Cluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant createdAt;
    private final String version;
    private final String endpoint;
    private final String roleArn;
    private final VpcConfigResponse resourcesVpcConfig;
    private final KubernetesNetworkConfigResponse kubernetesNetworkConfig;
    private final Logging logging;
    private final Identity identity;
    private final String status;
    private final Certificate certificateAuthority;
    private final String clientRequestToken;
    private final String platformVersion;
    private final Map<String, String> tags;
    private final List<EncryptionConfig> encryptionConfig;
    private final ConnectorConfigResponse connectorConfig;
    private final String id;
    private final ClusterHealth health;
    private final OutpostConfigResponse outpostConfig;
    private final AccessConfigResponse accessConfig;
    private final UpgradePolicyResponse upgradePolicy;
    private final ZonalShiftConfigResponse zonalShiftConfig;
    private final RemoteNetworkConfigResponse remoteNetworkConfig;
    private final ComputeConfigResponse computeConfig;
    private final StorageConfigResponse storageConfig;

    private Cluster(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.version = builder.version;
        this.endpoint = builder.endpoint;
        this.roleArn = builder.roleArn;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
        this.logging = builder.logging;
        this.identity = builder.identity;
        this.status = builder.status;
        this.certificateAuthority = builder.certificateAuthority;
        this.clientRequestToken = builder.clientRequestToken;
        this.platformVersion = builder.platformVersion;
        this.tags = builder.tags;
        this.encryptionConfig = builder.encryptionConfig;
        this.connectorConfig = builder.connectorConfig;
        this.id = builder.id;
        this.health = builder.health;
        this.outpostConfig = builder.outpostConfig;
        this.accessConfig = builder.accessConfig;
        this.upgradePolicy = builder.upgradePolicy;
        this.zonalShiftConfig = builder.zonalShiftConfig;
        this.remoteNetworkConfig = builder.remoteNetworkConfig;
        this.computeConfig = builder.computeConfig;
        this.storageConfig = builder.storageConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String version() {
        return this.version;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final VpcConfigResponse resourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public final KubernetesNetworkConfigResponse kubernetesNetworkConfig() {
        return this.kubernetesNetworkConfig;
    }

    public final Logging logging() {
        return this.logging;
    }

    public final Identity identity() {
        return this.identity;
    }

    public final ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Certificate certificateAuthority() {
        return this.certificateAuthority;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasEncryptionConfig() {
        return this.encryptionConfig != null && !(this.encryptionConfig instanceof SdkAutoConstructList);
    }

    public final List<EncryptionConfig> encryptionConfig() {
        return this.encryptionConfig;
    }

    public final ConnectorConfigResponse connectorConfig() {
        return this.connectorConfig;
    }

    public final String id() {
        return this.id;
    }

    public final ClusterHealth health() {
        return this.health;
    }

    public final OutpostConfigResponse outpostConfig() {
        return this.outpostConfig;
    }

    public final AccessConfigResponse accessConfig() {
        return this.accessConfig;
    }

    public final UpgradePolicyResponse upgradePolicy() {
        return this.upgradePolicy;
    }

    public final ZonalShiftConfigResponse zonalShiftConfig() {
        return this.zonalShiftConfig;
    }

    public final RemoteNetworkConfigResponse remoteNetworkConfig() {
        return this.remoteNetworkConfig;
    }

    public final ComputeConfigResponse computeConfig() {
        return this.computeConfig;
    }

    public final StorageConfigResponse storageConfig() {
        return this.storageConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthority());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionConfig() ? this.encryptionConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.health());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalShiftConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.resourcesVpcConfig(), other.resourcesVpcConfig()) && Objects.equals(this.kubernetesNetworkConfig(), other.kubernetesNetworkConfig()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.identity(), other.identity()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificateAuthority(), other.certificateAuthority()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.platformVersion(), other.platformVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasEncryptionConfig() == other.hasEncryptionConfig() && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.connectorConfig(), other.connectorConfig()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.health(), other.health()) && Objects.equals(this.outpostConfig(), other.outpostConfig()) && Objects.equals(this.accessConfig(), other.accessConfig()) && Objects.equals(this.upgradePolicy(), other.upgradePolicy()) && Objects.equals(this.zonalShiftConfig(), other.zonalShiftConfig()) && Objects.equals(this.remoteNetworkConfig(), other.remoteNetworkConfig()) && Objects.equals(this.computeConfig(), other.computeConfig()) && Objects.equals(this.storageConfig(), other.storageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Version", (Object)this.version()).add("Endpoint", (Object)this.endpoint()).add("RoleArn", (Object)this.roleArn()).add("ResourcesVpcConfig", (Object)this.resourcesVpcConfig()).add("KubernetesNetworkConfig", (Object)this.kubernetesNetworkConfig()).add("Logging", (Object)this.logging()).add("Identity", (Object)this.identity()).add("Status", (Object)this.statusAsString()).add("CertificateAuthority", (Object)this.certificateAuthority()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("PlatformVersion", (Object)this.platformVersion()).add("Tags", this.hasTags() ? this.tags() : null).add("EncryptionConfig", this.hasEncryptionConfig() ? this.encryptionConfig() : null).add("ConnectorConfig", (Object)this.connectorConfig()).add("Id", (Object)this.id()).add("Health", (Object)this.health()).add("OutpostConfig", (Object)this.outpostConfig()).add("AccessConfig", (Object)this.accessConfig()).add("UpgradePolicy", (Object)this.upgradePolicy()).add("ZonalShiftConfig", (Object)this.zonalShiftConfig()).add("RemoteNetworkConfig", (Object)this.remoteNetworkConfig()).add("ComputeConfig", (Object)this.computeConfig()).add("StorageConfig", (Object)this.storageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "resourcesVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.resourcesVpcConfig()));
            }
            case "kubernetesNetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.kubernetesNetworkConfig()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "certificateAuthority": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthority()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "encryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "connectorConfig": {
                return Optional.ofNullable(clazz.cast(this.connectorConfig()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.health()));
            }
            case "outpostConfig": {
                return Optional.ofNullable(clazz.cast(this.outpostConfig()));
            }
            case "accessConfig": {
                return Optional.ofNullable(clazz.cast(this.accessConfig()));
            }
            case "upgradePolicy": {
                return Optional.ofNullable(clazz.cast(this.upgradePolicy()));
            }
            case "zonalShiftConfig": {
                return Optional.ofNullable(clazz.cast(this.zonalShiftConfig()));
            }
            case "remoteNetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.remoteNetworkConfig()));
            }
            case "computeConfig": {
                return Optional.ofNullable(clazz.cast(this.computeConfig()));
            }
            case "storageConfig": {
                return Optional.ofNullable(clazz.cast(this.storageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("resourcesVpcConfig", RESOURCES_VPC_CONFIG_FIELD);
        map.put("kubernetesNetworkConfig", KUBERNETES_NETWORK_CONFIG_FIELD);
        map.put("logging", LOGGING_FIELD);
        map.put("identity", IDENTITY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("certificateAuthority", CERTIFICATE_AUTHORITY_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("platformVersion", PLATFORM_VERSION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("encryptionConfig", ENCRYPTION_CONFIG_FIELD);
        map.put("connectorConfig", CONNECTOR_CONFIG_FIELD);
        map.put("id", ID_FIELD);
        map.put("health", HEALTH_FIELD);
        map.put("outpostConfig", OUTPOST_CONFIG_FIELD);
        map.put("accessConfig", ACCESS_CONFIG_FIELD);
        map.put("upgradePolicy", UPGRADE_POLICY_FIELD);
        map.put("zonalShiftConfig", ZONAL_SHIFT_CONFIG_FIELD);
        map.put("remoteNetworkConfig", REMOTE_NETWORK_CONFIG_FIELD);
        map.put("computeConfig", COMPUTE_CONFIG_FIELD);
        map.put("storageConfig", STORAGE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant createdAt;
        private String version;
        private String endpoint;
        private String roleArn;
        private VpcConfigResponse resourcesVpcConfig;
        private KubernetesNetworkConfigResponse kubernetesNetworkConfig;
        private Logging logging;
        private Identity identity;
        private String status;
        private Certificate certificateAuthority;
        private String clientRequestToken;
        private String platformVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<EncryptionConfig> encryptionConfig = DefaultSdkAutoConstructList.getInstance();
        private ConnectorConfigResponse connectorConfig;
        private String id;
        private ClusterHealth health;
        private OutpostConfigResponse outpostConfig;
        private AccessConfigResponse accessConfig;
        private UpgradePolicyResponse upgradePolicy;
        private ZonalShiftConfigResponse zonalShiftConfig;
        private RemoteNetworkConfigResponse remoteNetworkConfig;
        private ComputeConfigResponse computeConfig;
        private StorageConfigResponse storageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.name(model.name);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.version(model.version);
            this.endpoint(model.endpoint);
            this.roleArn(model.roleArn);
            this.resourcesVpcConfig(model.resourcesVpcConfig);
            this.kubernetesNetworkConfig(model.kubernetesNetworkConfig);
            this.logging(model.logging);
            this.identity(model.identity);
            this.status(model.status);
            this.certificateAuthority(model.certificateAuthority);
            this.clientRequestToken(model.clientRequestToken);
            this.platformVersion(model.platformVersion);
            this.tags(model.tags);
            this.encryptionConfig(model.encryptionConfig);
            this.connectorConfig(model.connectorConfig);
            this.id(model.id);
            this.health(model.health);
            this.outpostConfig(model.outpostConfig);
            this.accessConfig(model.accessConfig);
            this.upgradePolicy(model.upgradePolicy);
            this.zonalShiftConfig(model.zonalShiftConfig);
            this.remoteNetworkConfig(model.remoteNetworkConfig);
            this.computeConfig(model.computeConfig);
            this.storageConfig(model.storageConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final VpcConfigResponse.Builder getResourcesVpcConfig() {
            return this.resourcesVpcConfig != null ? this.resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigResponse.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigResponse resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final KubernetesNetworkConfigResponse.Builder getKubernetesNetworkConfig() {
            return this.kubernetesNetworkConfig != null ? this.kubernetesNetworkConfig.toBuilder() : null;
        }

        public final void setKubernetesNetworkConfig(KubernetesNetworkConfigResponse.BuilderImpl kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig != null ? kubernetesNetworkConfig.build() : null;
        }

        @Override
        public final Builder kubernetesNetworkConfig(KubernetesNetworkConfigResponse kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final Identity.Builder getIdentity() {
            return this.identity != null ? this.identity.toBuilder() : null;
        }

        public final void setIdentity(Identity.BuilderImpl identity) {
            this.identity = identity != null ? identity.build() : null;
        }

        @Override
        public final Builder identity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Certificate.Builder getCertificateAuthority() {
            return this.certificateAuthority != null ? this.certificateAuthority.toBuilder() : null;
        }

        public final void setCertificateAuthority(Certificate.BuilderImpl certificateAuthority) {
            this.certificateAuthority = certificateAuthority != null ? certificateAuthority.build() : null;
        }

        @Override
        public final Builder certificateAuthority(Certificate certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<EncryptionConfig.Builder> getEncryptionConfig() {
            List<EncryptionConfig.Builder> result = EncryptionConfigListCopier.copyToBuilder(this.encryptionConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEncryptionConfig(Collection<EncryptionConfig.BuilderImpl> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copyFromBuilder(encryptionConfig);
        }

        @Override
        public final Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copy(encryptionConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(EncryptionConfig ... encryptionConfig) {
            this.encryptionConfig(Arrays.asList(encryptionConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(Consumer<EncryptionConfig.Builder> ... encryptionConfig) {
            this.encryptionConfig(Stream.of(encryptionConfig).map(c -> (EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectorConfigResponse.Builder getConnectorConfig() {
            return this.connectorConfig != null ? this.connectorConfig.toBuilder() : null;
        }

        public final void setConnectorConfig(ConnectorConfigResponse.BuilderImpl connectorConfig) {
            this.connectorConfig = connectorConfig != null ? connectorConfig.build() : null;
        }

        @Override
        public final Builder connectorConfig(ConnectorConfigResponse connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ClusterHealth.Builder getHealth() {
            return this.health != null ? this.health.toBuilder() : null;
        }

        public final void setHealth(ClusterHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(ClusterHealth health) {
            this.health = health;
            return this;
        }

        public final OutpostConfigResponse.Builder getOutpostConfig() {
            return this.outpostConfig != null ? this.outpostConfig.toBuilder() : null;
        }

        public final void setOutpostConfig(OutpostConfigResponse.BuilderImpl outpostConfig) {
            this.outpostConfig = outpostConfig != null ? outpostConfig.build() : null;
        }

        @Override
        public final Builder outpostConfig(OutpostConfigResponse outpostConfig) {
            this.outpostConfig = outpostConfig;
            return this;
        }

        public final AccessConfigResponse.Builder getAccessConfig() {
            return this.accessConfig != null ? this.accessConfig.toBuilder() : null;
        }

        public final void setAccessConfig(AccessConfigResponse.BuilderImpl accessConfig) {
            this.accessConfig = accessConfig != null ? accessConfig.build() : null;
        }

        @Override
        public final Builder accessConfig(AccessConfigResponse accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        public final UpgradePolicyResponse.Builder getUpgradePolicy() {
            return this.upgradePolicy != null ? this.upgradePolicy.toBuilder() : null;
        }

        public final void setUpgradePolicy(UpgradePolicyResponse.BuilderImpl upgradePolicy) {
            this.upgradePolicy = upgradePolicy != null ? upgradePolicy.build() : null;
        }

        @Override
        public final Builder upgradePolicy(UpgradePolicyResponse upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
            return this;
        }

        public final ZonalShiftConfigResponse.Builder getZonalShiftConfig() {
            return this.zonalShiftConfig != null ? this.zonalShiftConfig.toBuilder() : null;
        }

        public final void setZonalShiftConfig(ZonalShiftConfigResponse.BuilderImpl zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig != null ? zonalShiftConfig.build() : null;
        }

        @Override
        public final Builder zonalShiftConfig(ZonalShiftConfigResponse zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig;
            return this;
        }

        public final RemoteNetworkConfigResponse.Builder getRemoteNetworkConfig() {
            return this.remoteNetworkConfig != null ? this.remoteNetworkConfig.toBuilder() : null;
        }

        public final void setRemoteNetworkConfig(RemoteNetworkConfigResponse.BuilderImpl remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig != null ? remoteNetworkConfig.build() : null;
        }

        @Override
        public final Builder remoteNetworkConfig(RemoteNetworkConfigResponse remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig;
            return this;
        }

        public final ComputeConfigResponse.Builder getComputeConfig() {
            return this.computeConfig != null ? this.computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfigResponse.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfigResponse computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final StorageConfigResponse.Builder getStorageConfig() {
            return this.storageConfig != null ? this.storageConfig.toBuilder() : null;
        }

        public final void setStorageConfig(StorageConfigResponse.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public final Builder storageConfig(StorageConfigResponse storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder version(String var1);

        public Builder endpoint(String var1);

        public Builder roleArn(String var1);

        public Builder resourcesVpcConfig(VpcConfigResponse var1);

        default public Builder resourcesVpcConfig(Consumer<VpcConfigResponse.Builder> resourcesVpcConfig) {
            return this.resourcesVpcConfig((VpcConfigResponse)((VpcConfigResponse.Builder)VpcConfigResponse.builder().applyMutation(resourcesVpcConfig)).build());
        }

        public Builder kubernetesNetworkConfig(KubernetesNetworkConfigResponse var1);

        default public Builder kubernetesNetworkConfig(Consumer<KubernetesNetworkConfigResponse.Builder> kubernetesNetworkConfig) {
            return this.kubernetesNetworkConfig((KubernetesNetworkConfigResponse)((KubernetesNetworkConfigResponse.Builder)KubernetesNetworkConfigResponse.builder().applyMutation(kubernetesNetworkConfig)).build());
        }

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder identity(Identity var1);

        default public Builder identity(Consumer<Identity.Builder> identity) {
            return this.identity((Identity)((Identity.Builder)Identity.builder().applyMutation(identity)).build());
        }

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder certificateAuthority(Certificate var1);

        default public Builder certificateAuthority(Consumer<Certificate.Builder> certificateAuthority) {
            return this.certificateAuthority((Certificate)((Certificate.Builder)Certificate.builder().applyMutation(certificateAuthority)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder platformVersion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder encryptionConfig(Collection<EncryptionConfig> var1);

        public Builder encryptionConfig(EncryptionConfig ... var1);

        public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> ... var1);

        public Builder connectorConfig(ConnectorConfigResponse var1);

        default public Builder connectorConfig(Consumer<ConnectorConfigResponse.Builder> connectorConfig) {
            return this.connectorConfig((ConnectorConfigResponse)((ConnectorConfigResponse.Builder)ConnectorConfigResponse.builder().applyMutation(connectorConfig)).build());
        }

        public Builder id(String var1);

        public Builder health(ClusterHealth var1);

        default public Builder health(Consumer<ClusterHealth.Builder> health) {
            return this.health((ClusterHealth)((ClusterHealth.Builder)ClusterHealth.builder().applyMutation(health)).build());
        }

        public Builder outpostConfig(OutpostConfigResponse var1);

        default public Builder outpostConfig(Consumer<OutpostConfigResponse.Builder> outpostConfig) {
            return this.outpostConfig((OutpostConfigResponse)((OutpostConfigResponse.Builder)OutpostConfigResponse.builder().applyMutation(outpostConfig)).build());
        }

        public Builder accessConfig(AccessConfigResponse var1);

        default public Builder accessConfig(Consumer<AccessConfigResponse.Builder> accessConfig) {
            return this.accessConfig((AccessConfigResponse)((AccessConfigResponse.Builder)AccessConfigResponse.builder().applyMutation(accessConfig)).build());
        }

        public Builder upgradePolicy(UpgradePolicyResponse var1);

        default public Builder upgradePolicy(Consumer<UpgradePolicyResponse.Builder> upgradePolicy) {
            return this.upgradePolicy((UpgradePolicyResponse)((UpgradePolicyResponse.Builder)UpgradePolicyResponse.builder().applyMutation(upgradePolicy)).build());
        }

        public Builder zonalShiftConfig(ZonalShiftConfigResponse var1);

        default public Builder zonalShiftConfig(Consumer<ZonalShiftConfigResponse.Builder> zonalShiftConfig) {
            return this.zonalShiftConfig((ZonalShiftConfigResponse)((ZonalShiftConfigResponse.Builder)ZonalShiftConfigResponse.builder().applyMutation(zonalShiftConfig)).build());
        }

        public Builder remoteNetworkConfig(RemoteNetworkConfigResponse var1);

        default public Builder remoteNetworkConfig(Consumer<RemoteNetworkConfigResponse.Builder> remoteNetworkConfig) {
            return this.remoteNetworkConfig((RemoteNetworkConfigResponse)((RemoteNetworkConfigResponse.Builder)RemoteNetworkConfigResponse.builder().applyMutation(remoteNetworkConfig)).build());
        }

        public Builder computeConfig(ComputeConfigResponse var1);

        default public Builder computeConfig(Consumer<ComputeConfigResponse.Builder> computeConfig) {
            return this.computeConfig((ComputeConfigResponse)((ComputeConfigResponse.Builder)ComputeConfigResponse.builder().applyMutation(computeConfig)).build());
        }

        public Builder storageConfig(StorageConfigResponse var1);

        default public Builder storageConfig(Consumer<StorageConfigResponse.Builder> storageConfig) {
            return this.storageConfig((StorageConfigResponse)((StorageConfigResponse.Builder)StorageConfigResponse.builder().applyMutation(storageConfig)).build());
        }
    }
}

