/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateParamType {
    VERSION("Version"),
    PLATFORM_VERSION("PlatformVersion"),
    ENDPOINT_PRIVATE_ACCESS("EndpointPrivateAccess"),
    ENDPOINT_PUBLIC_ACCESS("EndpointPublicAccess"),
    CLUSTER_LOGGING("ClusterLogging"),
    DESIRED_SIZE("DesiredSize"),
    LABELS_TO_ADD("LabelsToAdd"),
    LABELS_TO_REMOVE("LabelsToRemove"),
    TAINTS_TO_ADD("TaintsToAdd"),
    TAINTS_TO_REMOVE("TaintsToRemove"),
    MAX_SIZE("MaxSize"),
    MIN_SIZE("MinSize"),
    RELEASE_VERSION("ReleaseVersion"),
    PUBLIC_ACCESS_CIDRS("PublicAccessCidrs"),
    LAUNCH_TEMPLATE_NAME("LaunchTemplateName"),
    LAUNCH_TEMPLATE_VERSION("LaunchTemplateVersion"),
    IDENTITY_PROVIDER_CONFIG("IdentityProviderConfig"),
    ENCRYPTION_CONFIG("EncryptionConfig"),
    ADDON_VERSION("AddonVersion"),
    SERVICE_ACCOUNT_ROLE_ARN("ServiceAccountRoleArn"),
    RESOLVE_CONFLICTS("ResolveConflicts"),
    MAX_UNAVAILABLE("MaxUnavailable"),
    MAX_UNAVAILABLE_PERCENTAGE("MaxUnavailablePercentage"),
    NODE_REPAIR_ENABLED("NodeRepairEnabled"),
    UPDATE_STRATEGY("UpdateStrategy"),
    CONFIGURATION_VALUES("ConfigurationValues"),
    SECURITY_GROUPS("SecurityGroups"),
    SUBNETS("Subnets"),
    AUTHENTICATION_MODE("AuthenticationMode"),
    POD_IDENTITY_ASSOCIATIONS("PodIdentityAssociations"),
    UPGRADE_POLICY("UpgradePolicy"),
    ZONAL_SHIFT_CONFIG("ZonalShiftConfig"),
    COMPUTE_CONFIG("ComputeConfig"),
    STORAGE_CONFIG("StorageConfig"),
    KUBERNETES_NETWORK_CONFIG("KubernetesNetworkConfig"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateParamType> VALUE_MAP;
    private final String value;

    private UpdateParamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateParamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateParamType> knownValues() {
        EnumSet<UpdateParamType> knownValues = EnumSet.allOf(UpdateParamType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateParamType.class, UpdateParamType::toString);
    }
}

