/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessEntry> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(AccessEntry.getter(AccessEntry::clusterName)).setter(AccessEntry.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(AccessEntry.getter(AccessEntry::principalArn)).setter(AccessEntry.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<List<String>> KUBERNETES_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kubernetesGroups").getter(AccessEntry.getter(AccessEntry::kubernetesGroups)).setter(AccessEntry.setter(Builder::kubernetesGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCESS_ENTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessEntryArn").getter(AccessEntry.getter(AccessEntry::accessEntryArn)).setter(AccessEntry.setter(Builder::accessEntryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessEntryArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AccessEntry.getter(AccessEntry::createdAt)).setter(AccessEntry.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(AccessEntry.getter(AccessEntry::modifiedAt)).setter(AccessEntry.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AccessEntry.getter(AccessEntry::tags)).setter(AccessEntry.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(AccessEntry.getter(AccessEntry::username)).setter(AccessEntry.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AccessEntry.getter(AccessEntry::type)).setter(AccessEntry.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, PRINCIPAL_ARN_FIELD, KUBERNETES_GROUPS_FIELD, ACCESS_ENTRY_ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, TAGS_FIELD, USERNAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String principalArn;
    private final List<String> kubernetesGroups;
    private final String accessEntryArn;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Map<String, String> tags;
    private final String username;
    private final String type;

    private AccessEntry(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.kubernetesGroups = builder.kubernetesGroups;
        this.accessEntryArn = builder.accessEntryArn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
        this.username = builder.username;
        this.type = builder.type;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final boolean hasKubernetesGroups() {
        return this.kubernetesGroups != null && !(this.kubernetesGroups instanceof SdkAutoConstructList);
    }

    public final List<String> kubernetesGroups() {
        return this.kubernetesGroups;
    }

    public final String accessEntryArn() {
        return this.accessEntryArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String username() {
        return this.username;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKubernetesGroups() ? this.kubernetesGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEntryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEntry)) {
            return false;
        }
        AccessEntry other = (AccessEntry)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.principalArn(), other.principalArn()) && this.hasKubernetesGroups() == other.hasKubernetesGroups() && Objects.equals(this.kubernetesGroups(), other.kubernetesGroups()) && Objects.equals(this.accessEntryArn(), other.accessEntryArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"AccessEntry").add("ClusterName", (Object)this.clusterName()).add("PrincipalArn", (Object)this.principalArn()).add("KubernetesGroups", this.hasKubernetesGroups() ? this.kubernetesGroups() : null).add("AccessEntryArn", (Object)this.accessEntryArn()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Tags", this.hasTags() ? this.tags() : null).add("Username", (Object)this.username()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "kubernetesGroups": {
                return Optional.ofNullable(clazz.cast(this.kubernetesGroups()));
            }
            case "accessEntryArn": {
                return Optional.ofNullable(clazz.cast(this.accessEntryArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        map.put("kubernetesGroups", KUBERNETES_GROUPS_FIELD);
        map.put("accessEntryArn", ACCESS_ENTRY_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessEntry, T> g) {
        return obj -> g.apply((AccessEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String principalArn;
        private List<String> kubernetesGroups = DefaultSdkAutoConstructList.getInstance();
        private String accessEntryArn;
        private Instant createdAt;
        private Instant modifiedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String username;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEntry model) {
            this.clusterName(model.clusterName);
            this.principalArn(model.principalArn);
            this.kubernetesGroups(model.kubernetesGroups);
            this.accessEntryArn(model.accessEntryArn);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.tags(model.tags);
            this.username(model.username);
            this.type(model.type);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Collection<String> getKubernetesGroups() {
            if (this.kubernetesGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.kubernetesGroups;
        }

        public final void setKubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
        }

        @Override
        public final Builder kubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kubernetesGroups(String ... kubernetesGroups) {
            this.kubernetesGroups(Arrays.asList(kubernetesGroups));
            return this;
        }

        public final String getAccessEntryArn() {
            return this.accessEntryArn;
        }

        public final void setAccessEntryArn(String accessEntryArn) {
            this.accessEntryArn = accessEntryArn;
        }

        @Override
        public final Builder accessEntryArn(String accessEntryArn) {
            this.accessEntryArn = accessEntryArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public AccessEntry build() {
            return new AccessEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessEntry> {
        public Builder clusterName(String var1);

        public Builder principalArn(String var1);

        public Builder kubernetesGroups(Collection<String> var1);

        public Builder kubernetesGroups(String ... var1);

        public Builder accessEntryArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder username(String var1);

        public Builder type(String var1);
    }
}

