/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.Category;
import software.amazon.awssdk.services.eks.model.CategoryListCopier;
import software.amazon.awssdk.services.eks.model.InsightStatusValue;
import software.amazon.awssdk.services.eks.model.InsightStatusValueListCopier;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightsFilter> {
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categories").getter(InsightsFilter.getter(InsightsFilter::categoriesAsStrings)).setter(InsightsFilter.setter(Builder::categoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KUBERNETES_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kubernetesVersions").getter(InsightsFilter.getter(InsightsFilter::kubernetesVersions)).setter(InsightsFilter.setter(Builder::kubernetesVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(InsightsFilter.getter(InsightsFilter::statusesAsStrings)).setter(InsightsFilter.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD, KUBERNETES_VERSIONS_FIELD, STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightsFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> categories;
    private final List<String> kubernetesVersions;
    private final List<String> statuses;

    private InsightsFilter(BuilderImpl builder) {
        this.categories = builder.categories;
        this.kubernetesVersions = builder.kubernetesVersions;
        this.statuses = builder.statuses;
    }

    public final List<Category> categories() {
        return CategoryListCopier.copyStringToEnum(this.categories);
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categoriesAsStrings() {
        return this.categories;
    }

    public final boolean hasKubernetesVersions() {
        return this.kubernetesVersions != null && !(this.kubernetesVersions instanceof SdkAutoConstructList);
    }

    public final List<String> kubernetesVersions() {
        return this.kubernetesVersions;
    }

    public final List<InsightStatusValue> statuses() {
        return InsightStatusValueListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKubernetesVersions() ? this.kubernetesVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightsFilter)) {
            return false;
        }
        InsightsFilter other = (InsightsFilter)obj;
        return this.hasCategories() == other.hasCategories() && Objects.equals(this.categoriesAsStrings(), other.categoriesAsStrings()) && this.hasKubernetesVersions() == other.hasKubernetesVersions() && Objects.equals(this.kubernetesVersions(), other.kubernetesVersions()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InsightsFilter").add("Categories", this.hasCategories() ? this.categoriesAsStrings() : null).add("KubernetesVersions", this.hasKubernetesVersions() ? this.kubernetesVersions() : null).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "categories": {
                return Optional.ofNullable(clazz.cast(this.categoriesAsStrings()));
            }
            case "kubernetesVersions": {
                return Optional.ofNullable(clazz.cast(this.kubernetesVersions()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("categories", CATEGORIES_FIELD);
        map.put("kubernetesVersions", KUBERNETES_VERSIONS_FIELD);
        map.put("statuses", STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightsFilter, T> g) {
        return obj -> g.apply((InsightsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private List<String> kubernetesVersions = DefaultSdkAutoConstructList.getInstance();
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightsFilter model) {
            this.categoriesWithStrings(model.categories);
            this.kubernetesVersions(model.kubernetesVersions);
            this.statusesWithStrings(model.statuses);
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categoriesWithStrings(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithStrings(String ... categories) {
            this.categoriesWithStrings(Arrays.asList(categories));
            return this;
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copyEnumToString(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final Collection<String> getKubernetesVersions() {
            if (this.kubernetesVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.kubernetesVersions;
        }

        public final void setKubernetesVersions(Collection<String> kubernetesVersions) {
            this.kubernetesVersions = StringListCopier.copy(kubernetesVersions);
        }

        @Override
        public final Builder kubernetesVersions(Collection<String> kubernetesVersions) {
            this.kubernetesVersions = StringListCopier.copy(kubernetesVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kubernetesVersions(String ... kubernetesVersions) {
            this.kubernetesVersions(Arrays.asList(kubernetesVersions));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = InsightStatusValueListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = InsightStatusValueListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<InsightStatusValue> statuses) {
            this.statuses = InsightStatusValueListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(InsightStatusValue ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public InsightsFilter build() {
            return new InsightsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightsFilter> {
        public Builder categoriesWithStrings(Collection<String> var1);

        public Builder categoriesWithStrings(String ... var1);

        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);

        public Builder kubernetesVersions(Collection<String> var1);

        public Builder kubernetesVersions(String ... var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<InsightStatusValue> var1);

        public Builder statuses(InsightStatusValue ... var1);
    }
}

