/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccessEntryRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateAccessEntryRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(UpdateAccessEntryRequest.getter(UpdateAccessEntryRequest::clusterName)).setter(UpdateAccessEntryRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(UpdateAccessEntryRequest.getter(UpdateAccessEntryRequest::principalArn)).setter(UpdateAccessEntryRequest.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalArn").build()}).build();
    private static final SdkField<List<String>> KUBERNETES_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kubernetesGroups").getter(UpdateAccessEntryRequest.getter(UpdateAccessEntryRequest::kubernetesGroups)).setter(UpdateAccessEntryRequest.setter(Builder::kubernetesGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateAccessEntryRequest.getter(UpdateAccessEntryRequest::clientRequestToken)).setter(UpdateAccessEntryRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(UpdateAccessEntryRequest.getter(UpdateAccessEntryRequest::username)).setter(UpdateAccessEntryRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, PRINCIPAL_ARN_FIELD, KUBERNETES_GROUPS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, USERNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", CLUSTER_NAME_FIELD);
            this.put("principalArn", PRINCIPAL_ARN_FIELD);
            this.put("kubernetesGroups", KUBERNETES_GROUPS_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("username", USERNAME_FIELD);
        }
    });
    private final String clusterName;
    private final String principalArn;
    private final List<String> kubernetesGroups;
    private final String clientRequestToken;
    private final String username;

    private UpdateAccessEntryRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.kubernetesGroups = builder.kubernetesGroups;
        this.clientRequestToken = builder.clientRequestToken;
        this.username = builder.username;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final boolean hasKubernetesGroups() {
        return this.kubernetesGroups != null && !(this.kubernetesGroups instanceof SdkAutoConstructList);
    }

    public final List<String> kubernetesGroups() {
        return this.kubernetesGroups;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKubernetesGroups() ? this.kubernetesGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessEntryRequest)) {
            return false;
        }
        UpdateAccessEntryRequest other = (UpdateAccessEntryRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.principalArn(), other.principalArn()) && this.hasKubernetesGroups() == other.hasKubernetesGroups() && Objects.equals(this.kubernetesGroups(), other.kubernetesGroups()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccessEntryRequest").add("ClusterName", (Object)this.clusterName()).add("PrincipalArn", (Object)this.principalArn()).add("KubernetesGroups", this.hasKubernetesGroups() ? this.kubernetesGroups() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Username", (Object)this.username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "kubernetesGroups": {
                return Optional.ofNullable(clazz.cast(this.kubernetesGroups()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessEntryRequest, T> g) {
        return obj -> g.apply((UpdateAccessEntryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String principalArn;
        private List<String> kubernetesGroups = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessEntryRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.principalArn(model.principalArn);
            this.kubernetesGroups(model.kubernetesGroups);
            this.clientRequestToken(model.clientRequestToken);
            this.username(model.username);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Collection<String> getKubernetesGroups() {
            if (this.kubernetesGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.kubernetesGroups;
        }

        public final void setKubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
        }

        @Override
        public final Builder kubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kubernetesGroups(String ... kubernetesGroups) {
            this.kubernetesGroups(Arrays.asList(kubernetesGroups));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessEntryRequest build() {
            return new UpdateAccessEntryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccessEntryRequest> {
        public Builder clusterName(String var1);

        public Builder principalArn(String var1);

        public Builder kubernetesGroups(Collection<String> var1);

        public Builder kubernetesGroups(String ... var1);

        public Builder clientRequestToken(String var1);

        public Builder username(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

