/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionLicenseType;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionTerm;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEksAnywhereSubscriptionRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateEksAnywhereSubscriptionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::name)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<EksAnywhereSubscriptionTerm> TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("term").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::term)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::term)).constructor(EksAnywhereSubscriptionTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()}).build();
    private static final SdkField<Integer> LICENSE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("licenseQuantity").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::licenseQuantity)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::licenseQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseQuantity").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseType").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::licenseTypeAsString)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoRenew").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::autoRenew)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRenew").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::clientRequestToken)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateEksAnywhereSubscriptionRequest.getter(CreateEksAnywhereSubscriptionRequest::tags)).setter(CreateEksAnywhereSubscriptionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TERM_FIELD, LICENSE_QUANTITY_FIELD, LICENSE_TYPE_FIELD, AUTO_RENEW_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("term", TERM_FIELD);
            this.put("licenseQuantity", LICENSE_QUANTITY_FIELD);
            this.put("licenseType", LICENSE_TYPE_FIELD);
            this.put("autoRenew", AUTO_RENEW_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final EksAnywhereSubscriptionTerm term;
    private final Integer licenseQuantity;
    private final String licenseType;
    private final Boolean autoRenew;
    private final String clientRequestToken;
    private final Map<String, String> tags;

    private CreateEksAnywhereSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.term = builder.term;
        this.licenseQuantity = builder.licenseQuantity;
        this.licenseType = builder.licenseType;
        this.autoRenew = builder.autoRenew;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final EksAnywhereSubscriptionTerm term() {
        return this.term;
    }

    public final Integer licenseQuantity() {
        return this.licenseQuantity;
    }

    public final EksAnywhereSubscriptionLicenseType licenseType() {
        return EksAnywhereSubscriptionLicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final Boolean autoRenew() {
        return this.autoRenew;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.term());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEksAnywhereSubscriptionRequest)) {
            return false;
        }
        CreateEksAnywhereSubscriptionRequest other = (CreateEksAnywhereSubscriptionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.term(), other.term()) && Objects.equals(this.licenseQuantity(), other.licenseQuantity()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEksAnywhereSubscriptionRequest").add("Name", (Object)this.name()).add("Term", (Object)this.term()).add("LicenseQuantity", (Object)this.licenseQuantity()).add("LicenseType", (Object)this.licenseTypeAsString()).add("AutoRenew", (Object)this.autoRenew()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "term": {
                return Optional.ofNullable(clazz.cast(this.term()));
            }
            case "licenseQuantity": {
                return Optional.ofNullable(clazz.cast(this.licenseQuantity()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "autoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenew()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEksAnywhereSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateEksAnywhereSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String name;
        private EksAnywhereSubscriptionTerm term;
        private Integer licenseQuantity;
        private String licenseType;
        private Boolean autoRenew;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEksAnywhereSubscriptionRequest model) {
            super(model);
            this.name(model.name);
            this.term(model.term);
            this.licenseQuantity(model.licenseQuantity);
            this.licenseType(model.licenseType);
            this.autoRenew(model.autoRenew);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EksAnywhereSubscriptionTerm.Builder getTerm() {
            return this.term != null ? this.term.toBuilder() : null;
        }

        public final void setTerm(EksAnywhereSubscriptionTerm.BuilderImpl term) {
            this.term = term != null ? term.build() : null;
        }

        @Override
        public final Builder term(EksAnywhereSubscriptionTerm term) {
            this.term = term;
            return this;
        }

        public final Integer getLicenseQuantity() {
            return this.licenseQuantity;
        }

        public final void setLicenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
        }

        @Override
        public final Builder licenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(EksAnywhereSubscriptionLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEksAnywhereSubscriptionRequest build() {
            return new CreateEksAnywhereSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEksAnywhereSubscriptionRequest> {
        public Builder name(String var1);

        public Builder term(EksAnywhereSubscriptionTerm var1);

        default public Builder term(Consumer<EksAnywhereSubscriptionTerm.Builder> term) {
            return this.term((EksAnywhereSubscriptionTerm)((EksAnywhereSubscriptionTerm.Builder)EksAnywhereSubscriptionTerm.builder().applyMutation(term)).build());
        }

        public Builder licenseQuantity(Integer var1);

        public Builder licenseType(String var1);

        public Builder licenseType(EksAnywhereSubscriptionLicenseType var1);

        public Builder autoRenew(Boolean var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

