/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.eks.model.DescribeAddonRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.waiters.EksWaiter;
import software.amazon.awssdk.services.eks.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultEksWaiter
implements EksWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final EksClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeClusterResponse> clusterActiveWaiter;
    private final Waiter<DescribeClusterResponse> clusterDeletedWaiter;
    private final Waiter<DescribeNodegroupResponse> nodegroupActiveWaiter;
    private final Waiter<DescribeNodegroupResponse> nodegroupDeletedWaiter;
    private final Waiter<DescribeAddonResponse> addonActiveWaiter;
    private final Waiter<DescribeAddonResponse> addonDeletedWaiter;
    private final Waiter<DescribeFargateProfileResponse> fargateProfileActiveWaiter;
    private final Waiter<DescribeFargateProfileResponse> fargateProfileDeletedWaiter;

    private DefaultEksWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EksClient)EksClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterResponse.class).acceptors(DefaultEksWaiter.clusterActiveWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.clusterActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.clusterDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterResponse.class).acceptors(DefaultEksWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.nodegroupActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNodegroupResponse.class).acceptors(DefaultEksWaiter.nodegroupActiveWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.nodegroupActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.nodegroupDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNodegroupResponse.class).acceptors(DefaultEksWaiter.nodegroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.nodegroupDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.addonActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAddonResponse.class).acceptors(DefaultEksWaiter.addonActiveWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.addonActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.addonDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAddonResponse.class).acceptors(DefaultEksWaiter.addonDeletedWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.addonDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.fargateProfileActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFargateProfileResponse.class).acceptors(DefaultEksWaiter.fargateProfileActiveWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.fargateProfileActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.fargateProfileDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFargateProfileResponse.class).acceptors(DefaultEksWaiter.fargateProfileDeletedWaiterAcceptors())).overrideConfiguration(DefaultEksWaiter.fargateProfileDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeAddonResponse> waitUntilAddonActive(DescribeAddonRequest describeAddonRequest) {
        return this.addonActiveWaiter.run(() -> this.client.describeAddon(this.applyWaitersUserAgent(describeAddonRequest)));
    }

    @Override
    public WaiterResponse<DescribeAddonResponse> waitUntilAddonActive(DescribeAddonRequest describeAddonRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.addonActiveWaiter.run(() -> this.client.describeAddon(this.applyWaitersUserAgent(describeAddonRequest)), DefaultEksWaiter.addonActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAddonResponse> waitUntilAddonDeleted(DescribeAddonRequest describeAddonRequest) {
        return this.addonDeletedWaiter.run(() -> this.client.describeAddon(this.applyWaitersUserAgent(describeAddonRequest)));
    }

    @Override
    public WaiterResponse<DescribeAddonResponse> waitUntilAddonDeleted(DescribeAddonRequest describeAddonRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.addonDeletedWaiter.run(() -> this.client.describeAddon(this.applyWaitersUserAgent(describeAddonRequest)), DefaultEksWaiter.addonDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterActive(DescribeClusterRequest describeClusterRequest) {
        return this.clusterActiveWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterActive(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterActiveWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEksWaiter.clusterActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest) {
        return this.clusterDeletedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEksWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFargateProfileResponse> waitUntilFargateProfileActive(DescribeFargateProfileRequest describeFargateProfileRequest) {
        return this.fargateProfileActiveWaiter.run(() -> this.client.describeFargateProfile(this.applyWaitersUserAgent(describeFargateProfileRequest)));
    }

    @Override
    public WaiterResponse<DescribeFargateProfileResponse> waitUntilFargateProfileActive(DescribeFargateProfileRequest describeFargateProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fargateProfileActiveWaiter.run(() -> this.client.describeFargateProfile(this.applyWaitersUserAgent(describeFargateProfileRequest)), DefaultEksWaiter.fargateProfileActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFargateProfileResponse> waitUntilFargateProfileDeleted(DescribeFargateProfileRequest describeFargateProfileRequest) {
        return this.fargateProfileDeletedWaiter.run(() -> this.client.describeFargateProfile(this.applyWaitersUserAgent(describeFargateProfileRequest)));
    }

    @Override
    public WaiterResponse<DescribeFargateProfileResponse> waitUntilFargateProfileDeleted(DescribeFargateProfileRequest describeFargateProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fargateProfileDeletedWaiter.run(() -> this.client.describeFargateProfile(this.applyWaitersUserAgent(describeFargateProfileRequest)), DefaultEksWaiter.fargateProfileDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNodegroupResponse> waitUntilNodegroupActive(DescribeNodegroupRequest describeNodegroupRequest) {
        return this.nodegroupActiveWaiter.run(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)));
    }

    @Override
    public WaiterResponse<DescribeNodegroupResponse> waitUntilNodegroupActive(DescribeNodegroupRequest describeNodegroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodegroupActiveWaiter.run(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)), DefaultEksWaiter.nodegroupActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNodegroupResponse> waitUntilNodegroupDeleted(DescribeNodegroupRequest describeNodegroupRequest) {
        return this.nodegroupDeletedWaiter.run(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)));
    }

    @Override
    public WaiterResponse<DescribeNodegroupResponse> waitUntilNodegroupDeleted(DescribeNodegroupRequest describeNodegroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodegroupDeletedWaiter.run(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)), DefaultEksWaiter.nodegroupDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "DELETING");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (cluster.status=DELETING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (cluster.status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "ACTIVE");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (cluster.status=ACTIVE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "CREATING");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (cluster.status=CREATING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "PENDING");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (cluster.status=PENDING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEksWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNodegroupResponse>> nodegroupActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("nodegroup").field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (nodegroup.status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("nodegroup").field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNodegroupResponse>> nodegroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("nodegroup").field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (nodegroup.status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEksWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAddonResponse>> addonActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAddonResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAddonResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("addon").field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (addon.status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("addon").field("status").value(), "DEGRADED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (addon.status=DEGRADED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("addon").field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAddonResponse>> addonDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAddonResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAddonResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("addon").field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (addon.status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEksWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFargateProfileResponse>> fargateProfileActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFargateProfileResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFargateProfileResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("fargateProfile").field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (fargateProfile.status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("fargateProfile").field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFargateProfileResponse>> fargateProfileDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFargateProfileResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFargateProfileResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("fargateProfile").field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (fargateProfile.status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEksWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration nodegroupActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(80);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration nodegroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration addonActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration addonDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fargateProfileActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fargateProfileDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EksWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EksRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EksRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EksWaiter.Builder {
        private EksClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public EksWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EksWaiter.Builder client(EksClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EksWaiter build() {
            return new DefaultEksWaiter(this);
        }
    }
}

