/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessScopeType {
    CLUSTER("cluster"),
    NAMESPACE("namespace"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessScopeType> VALUE_MAP;
    private final String value;

    private AccessScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessScopeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessScopeType> knownValues() {
        EnumSet<AccessScopeType> knownValues = EnumSet.allOf(AccessScopeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessScopeType.class, AccessScopeType::toString);
    }
}

