/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListNodegroupsRequest;
import software.amazon.awssdk.services.eks.model.ListNodegroupsResponse;

public class ListNodegroupsIterable
implements SdkIterable<ListNodegroupsResponse> {
    private final EksClient client;
    private final ListNodegroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNodegroupsIterable(EksClient client, ListNodegroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNodegroupsResponseFetcher();
    }

    public Iterator<ListNodegroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> nodegroups() {
        Function<ListNodegroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodegroups() != null) {
                return response.nodegroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNodegroupsResponseFetcher
    implements SyncPageFetcher<ListNodegroupsResponse> {
        private ListNodegroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListNodegroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNodegroupsResponse nextPage(ListNodegroupsResponse previousPage) {
            if (previousPage == null) {
                return ListNodegroupsIterable.this.client.listNodegroups(ListNodegroupsIterable.this.firstRequest);
            }
            return ListNodegroupsIterable.this.client.listNodegroups((ListNodegroupsRequest)((Object)ListNodegroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

