/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.FargateProfileIssue;
import software.amazon.awssdk.services.eks.model.FargateProfileIssueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FargateProfileHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FargateProfileHealth> {
    private static final SdkField<List<FargateProfileIssue>> ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("issues").getter(FargateProfileHealth.getter(FargateProfileHealth::issues)).setter(FargateProfileHealth.setter(Builder::issues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FargateProfileIssue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FargateProfileIssue> issues;

    private FargateProfileHealth(BuilderImpl builder) {
        this.issues = builder.issues;
    }

    public final boolean hasIssues() {
        return this.issues != null && !(this.issues instanceof SdkAutoConstructList);
    }

    public final List<FargateProfileIssue> issues() {
        return this.issues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssues() ? this.issues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateProfileHealth)) {
            return false;
        }
        FargateProfileHealth other = (FargateProfileHealth)obj;
        return this.hasIssues() == other.hasIssues() && Objects.equals(this.issues(), other.issues());
    }

    public final String toString() {
        return ToString.builder((String)"FargateProfileHealth").add("Issues", this.hasIssues() ? this.issues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FargateProfileHealth, T> g) {
        return obj -> g.apply((FargateProfileHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FargateProfileIssue> issues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FargateProfileHealth model) {
            this.issues(model.issues);
        }

        public final List<FargateProfileIssue.Builder> getIssues() {
            List<FargateProfileIssue.Builder> result = FargateProfileIssueListCopier.copyToBuilder(this.issues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssues(Collection<FargateProfileIssue.BuilderImpl> issues) {
            this.issues = FargateProfileIssueListCopier.copyFromBuilder(issues);
        }

        @Override
        public final Builder issues(Collection<FargateProfileIssue> issues) {
            this.issues = FargateProfileIssueListCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(FargateProfileIssue ... issues) {
            this.issues(Arrays.asList(issues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(Consumer<FargateProfileIssue.Builder> ... issues) {
            this.issues(Stream.of(issues).map(c -> (FargateProfileIssue)((FargateProfileIssue.Builder)FargateProfileIssue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FargateProfileHealth build() {
            return new FargateProfileHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FargateProfileHealth> {
        public Builder issues(Collection<FargateProfileIssue> var1);

        public Builder issues(FargateProfileIssue ... var1);

        public Builder issues(Consumer<FargateProfileIssue.Builder> ... var1);
    }
}

