/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListNodegroupsRequest;
import software.amazon.awssdk.services.eks.model.ListNodegroupsResponse;

public class ListNodegroupsPublisher
implements SdkPublisher<ListNodegroupsResponse> {
    private final EksAsyncClient client;
    private final ListNodegroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNodegroupsPublisher(EksAsyncClient client, ListNodegroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNodegroupsPublisher(EksAsyncClient client, ListNodegroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNodegroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNodegroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> nodegroups() {
        Function<ListNodegroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodegroups() != null) {
                return response.nodegroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNodegroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNodegroupsResponseFetcher
    implements AsyncPageFetcher<ListNodegroupsResponse> {
        private ListNodegroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListNodegroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNodegroupsResponse> nextPage(ListNodegroupsResponse previousPage) {
            if (previousPage == null) {
                return ListNodegroupsPublisher.this.client.listNodegroups(ListNodegroupsPublisher.this.firstRequest);
            }
            return ListNodegroupsPublisher.this.client.listNodegroups((ListNodegroupsRequest)((Object)ListNodegroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

