/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAccessPolicyResponse
extends EksResponse
implements ToCopyableBuilder<Builder, AssociateAccessPolicyResponse> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(AssociateAccessPolicyResponse.getter(AssociateAccessPolicyResponse::clusterName)).setter(AssociateAccessPolicyResponse.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(AssociateAccessPolicyResponse.getter(AssociateAccessPolicyResponse::principalArn)).setter(AssociateAccessPolicyResponse.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<AssociatedAccessPolicy> ASSOCIATED_ACCESS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("associatedAccessPolicy").getter(AssociateAccessPolicyResponse.getter(AssociateAccessPolicyResponse::associatedAccessPolicy)).setter(AssociateAccessPolicyResponse.setter(Builder::associatedAccessPolicy)).constructor(AssociatedAccessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccessPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, PRINCIPAL_ARN_FIELD, ASSOCIATED_ACCESS_POLICY_FIELD));
    private final String clusterName;
    private final String principalArn;
    private final AssociatedAccessPolicy associatedAccessPolicy;

    private AssociateAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.associatedAccessPolicy = builder.associatedAccessPolicy;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final AssociatedAccessPolicy associatedAccessPolicy() {
        return this.associatedAccessPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedAccessPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAccessPolicyResponse)) {
            return false;
        }
        AssociateAccessPolicyResponse other = (AssociateAccessPolicyResponse)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.associatedAccessPolicy(), other.associatedAccessPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAccessPolicyResponse").add("ClusterName", (Object)this.clusterName()).add("PrincipalArn", (Object)this.principalArn()).add("AssociatedAccessPolicy", (Object)this.associatedAccessPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "associatedAccessPolicy": {
                return Optional.ofNullable(clazz.cast(this.associatedAccessPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAccessPolicyResponse, T> g) {
        return obj -> g.apply((AssociateAccessPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private String clusterName;
        private String principalArn;
        private AssociatedAccessPolicy associatedAccessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAccessPolicyResponse model) {
            super(model);
            this.clusterName(model.clusterName);
            this.principalArn(model.principalArn);
            this.associatedAccessPolicy(model.associatedAccessPolicy);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final AssociatedAccessPolicy.Builder getAssociatedAccessPolicy() {
            return this.associatedAccessPolicy != null ? this.associatedAccessPolicy.toBuilder() : null;
        }

        public final void setAssociatedAccessPolicy(AssociatedAccessPolicy.BuilderImpl associatedAccessPolicy) {
            this.associatedAccessPolicy = associatedAccessPolicy != null ? associatedAccessPolicy.build() : null;
        }

        @Override
        public final Builder associatedAccessPolicy(AssociatedAccessPolicy associatedAccessPolicy) {
            this.associatedAccessPolicy = associatedAccessPolicy;
            return this;
        }

        @Override
        public AssociateAccessPolicyResponse build() {
            return new AssociateAccessPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAccessPolicyResponse> {
        public Builder clusterName(String var1);

        public Builder principalArn(String var1);

        public Builder associatedAccessPolicy(AssociatedAccessPolicy var1);

        default public Builder associatedAccessPolicy(Consumer<AssociatedAccessPolicy.Builder> associatedAccessPolicy) {
            return this.associatedAccessPolicy((AssociatedAccessPolicy)((AssociatedAccessPolicy.Builder)AssociatedAccessPolicy.builder().applyMutation(associatedAccessPolicy)).build());
        }
    }
}

