/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListAddonsRequest;
import software.amazon.awssdk.services.eks.model.ListAddonsResponse;

public class ListAddonsIterable
implements SdkIterable<ListAddonsResponse> {
    private final EksClient client;
    private final ListAddonsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAddonsIterable(EksClient client, ListAddonsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAddonsResponseFetcher();
    }

    public Iterator<ListAddonsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> addons() {
        Function<ListAddonsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addons() != null) {
                return response.addons().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAddonsResponseFetcher
    implements SyncPageFetcher<ListAddonsResponse> {
        private ListAddonsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddonsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAddonsResponse nextPage(ListAddonsResponse previousPage) {
            if (previousPage == null) {
                return ListAddonsIterable.this.client.listAddons(ListAddonsIterable.this.firstRequest);
            }
            return ListAddonsIterable.this.client.listAddons((ListAddonsRequest)((Object)ListAddonsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

