/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddonConfigurationResponse
extends EksResponse
implements ToCopyableBuilder<Builder, DescribeAddonConfigurationResponse> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::addonName)).setter(DescribeAddonConfigurationResponse.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()}).build();
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonVersion").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::addonVersion)).setter(DescribeAddonConfigurationResponse.setter(Builder::addonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()}).build();
    private static final SdkField<String> CONFIGURATION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationSchema").getter(DescribeAddonConfigurationResponse.getter(DescribeAddonConfigurationResponse::configurationSchema)).setter(DescribeAddonConfigurationResponse.setter(Builder::configurationSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD, ADDON_VERSION_FIELD, CONFIGURATION_SCHEMA_FIELD));
    private final String addonName;
    private final String addonVersion;
    private final String configurationSchema;

    private DescribeAddonConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
        this.configurationSchema = builder.configurationSchema;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final String addonVersion() {
        return this.addonVersion;
    }

    public final String configurationSchema() {
        return this.configurationSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddonConfigurationResponse)) {
            return false;
        }
        DescribeAddonConfigurationResponse other = (DescribeAddonConfigurationResponse)((Object)obj);
        return Objects.equals(this.addonName(), other.addonName()) && Objects.equals(this.addonVersion(), other.addonVersion()) && Objects.equals(this.configurationSchema(), other.configurationSchema());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAddonConfigurationResponse").add("AddonName", (Object)this.addonName()).add("AddonVersion", (Object)this.addonVersion()).add("ConfigurationSchema", (Object)this.configurationSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "addonVersion": {
                return Optional.ofNullable(clazz.cast(this.addonVersion()));
            }
            case "configurationSchema": {
                return Optional.ofNullable(clazz.cast(this.configurationSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddonConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAddonConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private String addonName;
        private String addonVersion;
        private String configurationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddonConfigurationResponse model) {
            super(model);
            this.addonName(model.addonName);
            this.addonVersion(model.addonVersion);
            this.configurationSchema(model.configurationSchema);
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonVersion() {
            return this.addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final String getConfigurationSchema() {
            return this.configurationSchema;
        }

        public final void setConfigurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
        }

        @Override
        public final Builder configurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
            return this;
        }

        @Override
        public DescribeAddonConfigurationResponse build() {
            return new DescribeAddonConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAddonConfigurationResponse> {
        public Builder addonName(String var1);

        public Builder addonVersion(String var1);

        public Builder configurationSchema(String var1);
    }
}

