/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse;

public class ListFargateProfilesPublisher
implements SdkPublisher<ListFargateProfilesResponse> {
    private final EksAsyncClient client;
    private final ListFargateProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFargateProfilesPublisher(EksAsyncClient client, ListFargateProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFargateProfilesPublisher(EksAsyncClient client, ListFargateProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFargateProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFargateProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> fargateProfileNames() {
        Function<ListFargateProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fargateProfileNames() != null) {
                return response.fargateProfileNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFargateProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFargateProfilesResponseFetcher
    implements AsyncPageFetcher<ListFargateProfilesResponse> {
        private ListFargateProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListFargateProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFargateProfilesResponse> nextPage(ListFargateProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListFargateProfilesPublisher.this.client.listFargateProfiles(ListFargateProfilesPublisher.this.firstRequest);
            }
            return ListFargateProfilesPublisher.this.client.listFargateProfiles((ListFargateProfilesRequest)((Object)ListFargateProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

