/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.services.eks.model.IdentityProviderConfig;
import software.amazon.awssdk.services.eks.model.IdentityProviderConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityProviderConfigsResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListIdentityProviderConfigsResponse> {
    private static final SdkField<List<IdentityProviderConfig>> IDENTITY_PROVIDER_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("identityProviderConfigs").getter(ListIdentityProviderConfigsResponse.getter(ListIdentityProviderConfigsResponse::identityProviderConfigs)).setter(ListIdentityProviderConfigsResponse.setter(Builder::identityProviderConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIdentityProviderConfigsResponse.getter(ListIdentityProviderConfigsResponse::nextToken)).setter(ListIdentityProviderConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IdentityProviderConfig> identityProviderConfigs;
    private final String nextToken;

    private ListIdentityProviderConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderConfigs = builder.identityProviderConfigs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIdentityProviderConfigs() {
        return this.identityProviderConfigs != null && !(this.identityProviderConfigs instanceof SdkAutoConstructList);
    }

    public final List<IdentityProviderConfig> identityProviderConfigs() {
        return this.identityProviderConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityProviderConfigs() ? this.identityProviderConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProviderConfigsResponse)) {
            return false;
        }
        ListIdentityProviderConfigsResponse other = (ListIdentityProviderConfigsResponse)((Object)obj);
        return this.hasIdentityProviderConfigs() == other.hasIdentityProviderConfigs() && Objects.equals(this.identityProviderConfigs(), other.identityProviderConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentityProviderConfigsResponse").add("IdentityProviderConfigs", this.hasIdentityProviderConfigs() ? this.identityProviderConfigs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identityProviderConfigs": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfigs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityProviderConfigsResponse, T> g) {
        return obj -> g.apply((ListIdentityProviderConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<IdentityProviderConfig> identityProviderConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProviderConfigsResponse model) {
            super(model);
            this.identityProviderConfigs(model.identityProviderConfigs);
            this.nextToken(model.nextToken);
        }

        public final List<IdentityProviderConfig.Builder> getIdentityProviderConfigs() {
            List<IdentityProviderConfig.Builder> result = IdentityProviderConfigsCopier.copyToBuilder(this.identityProviderConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityProviderConfigs(Collection<IdentityProviderConfig.BuilderImpl> identityProviderConfigs) {
            this.identityProviderConfigs = IdentityProviderConfigsCopier.copyFromBuilder(identityProviderConfigs);
        }

        @Override
        @Transient
        public final Builder identityProviderConfigs(Collection<IdentityProviderConfig> identityProviderConfigs) {
            this.identityProviderConfigs = IdentityProviderConfigsCopier.copy(identityProviderConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder identityProviderConfigs(IdentityProviderConfig ... identityProviderConfigs) {
            this.identityProviderConfigs(Arrays.asList(identityProviderConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder identityProviderConfigs(Consumer<IdentityProviderConfig.Builder> ... identityProviderConfigs) {
            this.identityProviderConfigs(Stream.of(identityProviderConfigs).map(c -> (IdentityProviderConfig)((IdentityProviderConfig.Builder)IdentityProviderConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityProviderConfigsResponse build() {
            return new ListIdentityProviderConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityProviderConfigsResponse> {
        public Builder identityProviderConfigs(Collection<IdentityProviderConfig> var1);

        public Builder identityProviderConfigs(IdentityProviderConfig ... var1);

        public Builder identityProviderConfigs(Consumer<IdentityProviderConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

