/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUpdateRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DescribeUpdateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DescribeUpdateRequest.getter(DescribeUpdateRequest::name)).setter(DescribeUpdateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> UPDATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateId").getter(DescribeUpdateRequest.getter(DescribeUpdateRequest::updateId)).setter(DescribeUpdateRequest.setter(Builder::updateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("updateId").build()}).build();
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodegroupName").getter(DescribeUpdateRequest.getter(DescribeUpdateRequest::nodegroupName)).setter(DescribeUpdateRequest.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nodegroupName").build()}).build();
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(DescribeUpdateRequest.getter(DescribeUpdateRequest::addonName)).setter(DescribeUpdateRequest.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("addonName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, UPDATE_ID_FIELD, NODEGROUP_NAME_FIELD, ADDON_NAME_FIELD));
    private final String name;
    private final String updateId;
    private final String nodegroupName;
    private final String addonName;

    private DescribeUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.updateId = builder.updateId;
        this.nodegroupName = builder.nodegroupName;
        this.addonName = builder.addonName;
    }

    public final String name() {
        return this.name;
    }

    public final String updateId() {
        return this.updateId;
    }

    public final String nodegroupName() {
        return this.nodegroupName;
    }

    public final String addonName() {
        return this.addonName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateRequest)) {
            return false;
        }
        DescribeUpdateRequest other = (DescribeUpdateRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.updateId(), other.updateId()) && Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.addonName(), other.addonName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUpdateRequest").add("Name", (Object)this.name()).add("UpdateId", (Object)this.updateId()).add("NodegroupName", (Object)this.nodegroupName()).add("AddonName", (Object)this.addonName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "updateId": {
                return Optional.ofNullable(clazz.cast(this.updateId()));
            }
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateRequest, T> g) {
        return obj -> g.apply((DescribeUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String name;
        private String updateId;
        private String nodegroupName;
        private String addonName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateRequest model) {
            super(model);
            this.name(model.name);
            this.updateId(model.updateId);
            this.nodegroupName(model.nodegroupName);
            this.addonName(model.addonName);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUpdateId() {
            return this.updateId;
        }

        public final void setUpdateId(String updateId) {
            this.updateId = updateId;
        }

        @Override
        @Transient
        public final Builder updateId(String updateId) {
            this.updateId = updateId;
            return this;
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        @Transient
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        @Transient
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUpdateRequest build() {
            return new DescribeUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUpdateRequest> {
        public Builder name(String var1);

        public Builder updateId(String var1);

        public Builder nodegroupName(String var1);

        public Builder addonName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

