/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.CompatibilitiesCopier;
import software.amazon.awssdk.services.eks.model.Compatibility;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddonVersionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddonVersionInfo> {
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonVersion").getter(AddonVersionInfo.getter(AddonVersionInfo::addonVersion)).setter(AddonVersionInfo.setter(Builder::addonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("architecture").getter(AddonVersionInfo.getter(AddonVersionInfo::architecture)).setter(AddonVersionInfo.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Compatibility>> COMPATIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("compatibilities").getter(AddonVersionInfo.getter(AddonVersionInfo::compatibilities)).setter(AddonVersionInfo.setter(Builder::compatibilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Compatibility::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_VERSION_FIELD, ARCHITECTURE_FIELD, COMPATIBILITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addonVersion;
    private final List<String> architecture;
    private final List<Compatibility> compatibilities;

    private AddonVersionInfo(BuilderImpl builder) {
        this.addonVersion = builder.addonVersion;
        this.architecture = builder.architecture;
        this.compatibilities = builder.compatibilities;
    }

    public final String addonVersion() {
        return this.addonVersion;
    }

    public final boolean hasArchitecture() {
        return this.architecture != null && !(this.architecture instanceof SdkAutoConstructList);
    }

    public final List<String> architecture() {
        return this.architecture;
    }

    public final boolean hasCompatibilities() {
        return this.compatibilities != null && !(this.compatibilities instanceof SdkAutoConstructList);
    }

    public final List<Compatibility> compatibilities() {
        return this.compatibilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitecture() ? this.architecture() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibilities() ? this.compatibilities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonVersionInfo)) {
            return false;
        }
        AddonVersionInfo other = (AddonVersionInfo)obj;
        return Objects.equals(this.addonVersion(), other.addonVersion()) && this.hasArchitecture() == other.hasArchitecture() && Objects.equals(this.architecture(), other.architecture()) && this.hasCompatibilities() == other.hasCompatibilities() && Objects.equals(this.compatibilities(), other.compatibilities());
    }

    public final String toString() {
        return ToString.builder((String)"AddonVersionInfo").add("AddonVersion", (Object)this.addonVersion()).add("Architecture", this.hasArchitecture() ? this.architecture() : null).add("Compatibilities", this.hasCompatibilities() ? this.compatibilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addonVersion": {
                return Optional.ofNullable(clazz.cast(this.addonVersion()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "compatibilities": {
                return Optional.ofNullable(clazz.cast(this.compatibilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddonVersionInfo, T> g) {
        return obj -> g.apply((AddonVersionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addonVersion;
        private List<String> architecture = DefaultSdkAutoConstructList.getInstance();
        private List<Compatibility> compatibilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddonVersionInfo model) {
            this.addonVersion(model.addonVersion);
            this.architecture(model.architecture);
            this.compatibilities(model.compatibilities);
        }

        public final String getAddonVersion() {
            return this.addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        @Transient
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final Collection<String> getArchitecture() {
            if (this.architecture instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architecture;
        }

        public final void setArchitecture(Collection<String> architecture) {
            this.architecture = StringListCopier.copy(architecture);
        }

        @Override
        @Transient
        public final Builder architecture(Collection<String> architecture) {
            this.architecture = StringListCopier.copy(architecture);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architecture(String ... architecture) {
            this.architecture(Arrays.asList(architecture));
            return this;
        }

        public final List<Compatibility.Builder> getCompatibilities() {
            List<Compatibility.Builder> result = CompatibilitiesCopier.copyToBuilder(this.compatibilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompatibilities(Collection<Compatibility.BuilderImpl> compatibilities) {
            this.compatibilities = CompatibilitiesCopier.copyFromBuilder(compatibilities);
        }

        @Override
        @Transient
        public final Builder compatibilities(Collection<Compatibility> compatibilities) {
            this.compatibilities = CompatibilitiesCopier.copy(compatibilities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder compatibilities(Compatibility ... compatibilities) {
            this.compatibilities(Arrays.asList(compatibilities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder compatibilities(Consumer<Compatibility.Builder> ... compatibilities) {
            this.compatibilities(Stream.of(compatibilities).map(c -> (Compatibility)((Compatibility.Builder)Compatibility.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AddonVersionInfo build() {
            return new AddonVersionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddonVersionInfo> {
        public Builder addonVersion(String var1);

        public Builder architecture(Collection<String> var1);

        public Builder architecture(String ... var1);

        public Builder compatibilities(Collection<Compatibility> var1);

        public Builder compatibilities(Compatibility ... var1);

        public Builder compatibilities(Consumer<Compatibility.Builder> ... var1);
    }
}

