/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AddonStatus {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DELETE_FAILED("DELETE_FAILED"),
    DEGRADED("DEGRADED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AddonStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddonStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AddonStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddonStatus> knownValues() {
        return Stream.of(AddonStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

