/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.model.IdentityProviderConfig;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse;

public class ListIdentityProviderConfigsIterable
implements SdkIterable<ListIdentityProviderConfigsResponse> {
    private final EksClient client;
    private final ListIdentityProviderConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdentityProviderConfigsIterable(EksClient client, ListIdentityProviderConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIdentityProviderConfigsResponseFetcher();
    }

    public Iterator<ListIdentityProviderConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdentityProviderConfig> identityProviderConfigs() {
        Function<ListIdentityProviderConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.identityProviderConfigs() != null) {
                return response.identityProviderConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdentityProviderConfigsResponseFetcher
    implements SyncPageFetcher<ListIdentityProviderConfigsResponse> {
        private ListIdentityProviderConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityProviderConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdentityProviderConfigsResponse nextPage(ListIdentityProviderConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityProviderConfigsIterable.this.client.listIdentityProviderConfigs(ListIdentityProviderConfigsIterable.this.firstRequest);
            }
            return ListIdentityProviderConfigsIterable.this.client.listIdentityProviderConfigs((ListIdentityProviderConfigsRequest)((Object)ListIdentityProviderConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

