/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.waiters.EksAsyncWaiter;
import software.amazon.awssdk.services.eks.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultEksAsyncWaiter
implements EksAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final EksAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeClusterResponse> clusterActiveWaiter;
    private final AsyncWaiter<DescribeClusterResponse> clusterDeletedWaiter;
    private final AsyncWaiter<DescribeNodegroupResponse> nodegroupActiveWaiter;
    private final AsyncWaiter<DescribeNodegroupResponse> nodegroupDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultEksAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EksAsyncClient)EksAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultEksAsyncWaiter.clusterActiveWaiterAcceptors())).overrideConfiguration(DefaultEksAsyncWaiter.clusterActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultEksAsyncWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultEksAsyncWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.nodegroupActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNodegroupResponse.class).acceptors(DefaultEksAsyncWaiter.nodegroupActiveWaiterAcceptors())).overrideConfiguration(DefaultEksAsyncWaiter.nodegroupActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.nodegroupDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNodegroupResponse.class).acceptors(DefaultEksAsyncWaiter.nodegroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultEksAsyncWaiter.nodegroupDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterActive(DescribeClusterRequest describeClusterRequest) {
        return this.clusterActiveWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterActive(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterActiveWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEksAsyncWaiter.clusterActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEksAsyncWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupActive(DescribeNodegroupRequest describeNodegroupRequest) {
        return this.nodegroupActiveWaiter.runAsync(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupActive(DescribeNodegroupRequest describeNodegroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodegroupActiveWaiter.runAsync(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)), DefaultEksAsyncWaiter.nodegroupActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupDeleted(DescribeNodegroupRequest describeNodegroupRequest) {
        return this.nodegroupDeletedWaiter.runAsync(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodegroupResponse>> waitUntilNodegroupDeleted(DescribeNodegroupRequest describeNodegroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodegroupDeletedWaiter.runAsync(() -> this.client.describeNodegroup(this.applyWaitersUserAgent(describeNodegroupRequest)), DefaultEksAsyncWaiter.nodegroupDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("cluster").field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEksAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNodegroupResponse>> nodegroupActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("nodegroup").field("status").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("nodegroup").field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNodegroupResponse>> nodegroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodegroupResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("nodegroup").field("status").value(), "DELETE_FAILED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEksAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration nodegroupActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(80);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration nodegroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EksAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EksRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EksRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EksAsyncWaiter.Builder {
        private EksAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public EksAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public EksAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EksAsyncWaiter.Builder client(EksAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EksAsyncWaiter build() {
            return new DefaultEksAsyncWaiter(this);
        }
    }
}

