/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AMITypes;
import software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.eks.model.NodegroupHealth;
import software.amazon.awssdk.services.eks.model.NodegroupResources;
import software.amazon.awssdk.services.eks.model.NodegroupScalingConfig;
import software.amazon.awssdk.services.eks.model.NodegroupStatus;
import software.amazon.awssdk.services.eks.model.RemoteAccessConfig;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.services.eks.model._labelsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Nodegroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Nodegroup> {
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::nodegroupName)).setter(Nodegroup.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()}).build();
    private static final SdkField<String> NODEGROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::nodegroupArn)).setter(Nodegroup.setter(Builder::nodegroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::clusterName)).setter(Nodegroup.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::version)).setter(Nodegroup.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::releaseVersion)).setter(Nodegroup.setter(Builder::releaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Nodegroup.getter(Nodegroup::createdAt)).setter(Nodegroup.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Nodegroup.getter(Nodegroup::modifiedAt)).setter(Nodegroup.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::statusAsString)).setter(Nodegroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Nodegroup.getter(Nodegroup::scalingConfig)).setter(Nodegroup.setter(Builder::scalingConfig)).constructor(NodegroupScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Nodegroup.getter(Nodegroup::instanceTypes)).setter(Nodegroup.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Nodegroup.getter(Nodegroup::subnets)).setter(Nodegroup.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RemoteAccessConfig> REMOTE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Nodegroup.getter(Nodegroup::remoteAccess)).setter(Nodegroup.setter(Builder::remoteAccess)).constructor(RemoteAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccess").build()}).build();
    private static final SdkField<String> AMI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::amiTypeAsString)).setter(Nodegroup.setter(Builder::amiType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiType").build()}).build();
    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Nodegroup.getter(Nodegroup::nodeRole)).setter(Nodegroup.setter(Builder::nodeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRole").build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Nodegroup.getter(Nodegroup::labels)).setter(Nodegroup.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<NodegroupResources> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Nodegroup.getter(Nodegroup::resources)).setter(Nodegroup.setter(Builder::resources)).constructor(NodegroupResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build()}).build();
    private static final SdkField<Integer> DISK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Nodegroup.getter(Nodegroup::diskSize)).setter(Nodegroup.setter(Builder::diskSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSize").build()}).build();
    private static final SdkField<NodegroupHealth> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Nodegroup.getter(Nodegroup::health)).setter(Nodegroup.setter(Builder::health)).constructor(NodegroupHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Nodegroup.getter(Nodegroup::launchTemplate)).setter(Nodegroup.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Nodegroup.getter(Nodegroup::tags)).setter(Nodegroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODEGROUP_NAME_FIELD, NODEGROUP_ARN_FIELD, CLUSTER_NAME_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD, SCALING_CONFIG_FIELD, INSTANCE_TYPES_FIELD, SUBNETS_FIELD, REMOTE_ACCESS_FIELD, AMI_TYPE_FIELD, NODE_ROLE_FIELD, LABELS_FIELD, RESOURCES_FIELD, DISK_SIZE_FIELD, HEALTH_FIELD, LAUNCH_TEMPLATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodegroupName;
    private final String nodegroupArn;
    private final String clusterName;
    private final String version;
    private final String releaseVersion;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String status;
    private final NodegroupScalingConfig scalingConfig;
    private final List<String> instanceTypes;
    private final List<String> subnets;
    private final RemoteAccessConfig remoteAccess;
    private final String amiType;
    private final String nodeRole;
    private final Map<String, String> labels;
    private final NodegroupResources resources;
    private final Integer diskSize;
    private final NodegroupHealth health;
    private final LaunchTemplateSpecification launchTemplate;
    private final Map<String, String> tags;

    private Nodegroup(BuilderImpl builder) {
        this.nodegroupName = builder.nodegroupName;
        this.nodegroupArn = builder.nodegroupArn;
        this.clusterName = builder.clusterName;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.scalingConfig = builder.scalingConfig;
        this.instanceTypes = builder.instanceTypes;
        this.subnets = builder.subnets;
        this.remoteAccess = builder.remoteAccess;
        this.amiType = builder.amiType;
        this.nodeRole = builder.nodeRole;
        this.labels = builder.labels;
        this.resources = builder.resources;
        this.diskSize = builder.diskSize;
        this.health = builder.health;
        this.launchTemplate = builder.launchTemplate;
        this.tags = builder.tags;
    }

    public String nodegroupName() {
        return this.nodegroupName;
    }

    public String nodegroupArn() {
        return this.nodegroupArn;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String version() {
        return this.version;
    }

    public String releaseVersion() {
        return this.releaseVersion;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant modifiedAt() {
        return this.modifiedAt;
    }

    public NodegroupStatus status() {
        return NodegroupStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public NodegroupScalingConfig scalingConfig() {
        return this.scalingConfig;
    }

    public boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public RemoteAccessConfig remoteAccess() {
        return this.remoteAccess;
    }

    public AMITypes amiType() {
        return AMITypes.fromValue(this.amiType);
    }

    public String amiTypeAsString() {
        return this.amiType;
    }

    public String nodeRole() {
        return this.nodeRole;
    }

    public boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public NodegroupResources resources() {
        return this.resources;
    }

    public Integer diskSize() {
        return this.diskSize;
    }

    public NodegroupHealth health() {
        return this.health;
    }

    public LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.health());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nodegroup)) {
            return false;
        }
        Nodegroup other = (Nodegroup)obj;
        return Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.nodegroupArn(), other.nodegroupArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releaseVersion(), other.releaseVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.scalingConfig(), other.scalingConfig()) && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.remoteAccess(), other.remoteAccess()) && Objects.equals(this.amiTypeAsString(), other.amiTypeAsString()) && Objects.equals(this.nodeRole(), other.nodeRole()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.diskSize(), other.diskSize()) && Objects.equals(this.health(), other.health()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Nodegroup").add("NodegroupName", (Object)this.nodegroupName()).add("NodegroupArn", (Object)this.nodegroupArn()).add("ClusterName", (Object)this.clusterName()).add("Version", (Object)this.version()).add("ReleaseVersion", (Object)this.releaseVersion()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Status", (Object)this.statusAsString()).add("ScalingConfig", (Object)this.scalingConfig()).add("InstanceTypes", this.instanceTypes()).add("Subnets", this.subnets()).add("RemoteAccess", (Object)this.remoteAccess()).add("AmiType", (Object)this.amiTypeAsString()).add("NodeRole", (Object)this.nodeRole()).add("Labels", this.labels()).add("Resources", (Object)this.resources()).add("DiskSize", (Object)this.diskSize()).add("Health", (Object)this.health()).add("LaunchTemplate", (Object)this.launchTemplate()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "nodegroupArn": {
                return Optional.ofNullable(clazz.cast(this.nodegroupArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releaseVersion": {
                return Optional.ofNullable(clazz.cast(this.releaseVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "scalingConfig": {
                return Optional.ofNullable(clazz.cast(this.scalingConfig()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "remoteAccess": {
                return Optional.ofNullable(clazz.cast(this.remoteAccess()));
            }
            case "amiType": {
                return Optional.ofNullable(clazz.cast(this.amiTypeAsString()));
            }
            case "nodeRole": {
                return Optional.ofNullable(clazz.cast(this.nodeRole()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "diskSize": {
                return Optional.ofNullable(clazz.cast(this.diskSize()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.health()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Nodegroup, T> g) {
        return obj -> g.apply((Nodegroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodegroupName;
        private String nodegroupArn;
        private String clusterName;
        private String version;
        private String releaseVersion;
        private Instant createdAt;
        private Instant modifiedAt;
        private String status;
        private NodegroupScalingConfig scalingConfig;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private RemoteAccessConfig remoteAccess;
        private String amiType;
        private String nodeRole;
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private NodegroupResources resources;
        private Integer diskSize;
        private NodegroupHealth health;
        private LaunchTemplateSpecification launchTemplate;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Nodegroup model) {
            this.nodegroupName(model.nodegroupName);
            this.nodegroupArn(model.nodegroupArn);
            this.clusterName(model.clusterName);
            this.version(model.version);
            this.releaseVersion(model.releaseVersion);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.status(model.status);
            this.scalingConfig(model.scalingConfig);
            this.instanceTypes(model.instanceTypes);
            this.subnets(model.subnets);
            this.remoteAccess(model.remoteAccess);
            this.amiType(model.amiType);
            this.nodeRole(model.nodeRole);
            this.labels(model.labels);
            this.resources(model.resources);
            this.diskSize(model.diskSize);
            this.health(model.health);
            this.launchTemplate(model.launchTemplate);
            this.tags(model.tags);
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final String getNodegroupArn() {
            return this.nodegroupArn;
        }

        @Override
        public final Builder nodegroupArn(String nodegroupArn) {
            this.nodegroupArn = nodegroupArn;
            return this;
        }

        public final void setNodegroupArn(String nodegroupArn) {
            this.nodegroupArn = nodegroupArn;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NodegroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return this.scalingConfig != null ? this.scalingConfig.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final RemoteAccessConfig.Builder getRemoteAccess() {
            return this.remoteAccess != null ? this.remoteAccess.toBuilder() : null;
        }

        @Override
        public final Builder remoteAccess(RemoteAccessConfig remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public final void setRemoteAccess(RemoteAccessConfig.BuilderImpl remoteAccess) {
            this.remoteAccess = remoteAccess != null ? remoteAccess.build() : null;
        }

        public final String getAmiType() {
            return this.amiType;
        }

        @Override
        public final Builder amiType(String amiType) {
            this.amiType = amiType;
            return this;
        }

        @Override
        public final Builder amiType(AMITypes amiType) {
            this.amiType(amiType == null ? null : amiType.toString());
            return this;
        }

        public final void setAmiType(String amiType) {
            this.amiType = amiType;
        }

        public final String getNodeRole() {
            return this.nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        public final Map<String, String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
        }

        public final NodegroupResources.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(NodegroupResources resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(NodegroupResources.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final Integer getDiskSize() {
            return this.diskSize;
        }

        @Override
        public final Builder diskSize(Integer diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public final void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        public final NodegroupHealth.Builder getHealth() {
            return this.health != null ? this.health.toBuilder() : null;
        }

        @Override
        public final Builder health(NodegroupHealth health) {
            this.health = health;
            return this;
        }

        public final void setHealth(NodegroupHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public Nodegroup build() {
            return new Nodegroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Nodegroup> {
        public Builder nodegroupName(String var1);

        public Builder nodegroupArn(String var1);

        public Builder clusterName(String var1);

        public Builder version(String var1);

        public Builder releaseVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(NodegroupStatus var1);

        public Builder scalingConfig(NodegroupScalingConfig var1);

        default public Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return this.scalingConfig((NodegroupScalingConfig)((NodegroupScalingConfig.Builder)NodegroupScalingConfig.builder().applyMutation(scalingConfig)).build());
        }

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder remoteAccess(RemoteAccessConfig var1);

        default public Builder remoteAccess(Consumer<RemoteAccessConfig.Builder> remoteAccess) {
            return this.remoteAccess((RemoteAccessConfig)((RemoteAccessConfig.Builder)RemoteAccessConfig.builder().applyMutation(remoteAccess)).build());
        }

        public Builder amiType(String var1);

        public Builder amiType(AMITypes var1);

        public Builder nodeRole(String var1);

        public Builder labels(Map<String, String> var1);

        public Builder resources(NodegroupResources var1);

        default public Builder resources(Consumer<NodegroupResources.Builder> resources) {
            return this.resources((NodegroupResources)((NodegroupResources.Builder)NodegroupResources.builder().applyMutation(resources)).build());
        }

        public Builder diskSize(Integer var1);

        public Builder health(NodegroupHealth var1);

        default public Builder health(Consumer<NodegroupHealth.Builder> health) {
            return this.health((NodegroupHealth)((NodegroupHealth.Builder)NodegroupHealth.builder().applyMutation(health)).build());
        }

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

