/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.Provider;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionConfig> {
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EncryptionConfig.getter(EncryptionConfig::resources)).setter(EncryptionConfig.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Provider> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncryptionConfig.getter(EncryptionConfig::provider)).setter(EncryptionConfig.setter(Builder::provider)).constructor(Provider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD, PROVIDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> resources;
    private final Provider provider;

    private EncryptionConfig(BuilderImpl builder) {
        this.resources = builder.resources;
        this.provider = builder.provider;
    }

    public boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public List<String> resources() {
        return this.resources;
    }

    public Provider provider() {
        return this.provider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfig)) {
            return false;
        }
        EncryptionConfig other = (EncryptionConfig)obj;
        return Objects.equals(this.resources(), other.resources()) && Objects.equals(this.provider(), other.provider());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionConfig").add("Resources", this.resources()).add("Provider", (Object)this.provider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfig, T> g) {
        return obj -> g.apply((EncryptionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private Provider provider;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfig model) {
            this.resources(model.resources);
            this.provider(model.provider);
        }

        public final Collection<String> getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = StringListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = StringListCopier.copy(resources);
        }

        public final Provider.Builder getProvider() {
            return this.provider != null ? this.provider.toBuilder() : null;
        }

        @Override
        public final Builder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(Provider.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        public EncryptionConfig build() {
            return new EncryptionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionConfig> {
        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder provider(Provider var1);

        default public Builder provider(Consumer<Provider.Builder> provider) {
            return this.provider((Provider)((Provider.Builder)Provider.builder().applyMutation(provider)).build());
        }
    }
}

