/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AMITypes {
    AL2_X86_64("AL2_x86_64"),
    AL2_X86_64_GPU("AL2_x86_64_GPU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AMITypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AMITypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AMITypes.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AMITypes> knownValues() {
        return Stream.of(AMITypes.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

