/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AMITypes;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.NodegroupScalingConfig;
import software.amazon.awssdk.services.eks.model.RemoteAccessConfig;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.services.eks.model._labelsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNodegroupRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateNodegroupRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::clusterName)).setter(CreateNodegroupRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::nodegroupName)).setter(CreateNodegroupRequest.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()}).build();
    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::scalingConfig)).setter(CreateNodegroupRequest.setter(Builder::scalingConfig)).constructor(NodegroupScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()}).build();
    private static final SdkField<Integer> DISK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::diskSize)).setter(CreateNodegroupRequest.setter(Builder::diskSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSize").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::subnets)).setter(CreateNodegroupRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::instanceTypes)).setter(CreateNodegroupRequest.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AMI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::amiTypeAsString)).setter(CreateNodegroupRequest.setter(Builder::amiType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiType").build()}).build();
    private static final SdkField<RemoteAccessConfig> REMOTE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::remoteAccess)).setter(CreateNodegroupRequest.setter(Builder::remoteAccess)).constructor(RemoteAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccess").build()}).build();
    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::nodeRole)).setter(CreateNodegroupRequest.setter(Builder::nodeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRole").build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::labels)).setter(CreateNodegroupRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::tags)).setter(CreateNodegroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::clientRequestToken)).setter(CreateNodegroupRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::version)).setter(CreateNodegroupRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::releaseVersion)).setter(CreateNodegroupRequest.setter(Builder::releaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODEGROUP_NAME_FIELD, SCALING_CONFIG_FIELD, DISK_SIZE_FIELD, SUBNETS_FIELD, INSTANCE_TYPES_FIELD, AMI_TYPE_FIELD, REMOTE_ACCESS_FIELD, NODE_ROLE_FIELD, LABELS_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD));
    private final String clusterName;
    private final String nodegroupName;
    private final NodegroupScalingConfig scalingConfig;
    private final Integer diskSize;
    private final List<String> subnets;
    private final List<String> instanceTypes;
    private final String amiType;
    private final RemoteAccessConfig remoteAccess;
    private final String nodeRole;
    private final Map<String, String> labels;
    private final Map<String, String> tags;
    private final String clientRequestToken;
    private final String version;
    private final String releaseVersion;

    private CreateNodegroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.scalingConfig = builder.scalingConfig;
        this.diskSize = builder.diskSize;
        this.subnets = builder.subnets;
        this.instanceTypes = builder.instanceTypes;
        this.amiType = builder.amiType;
        this.remoteAccess = builder.remoteAccess;
        this.nodeRole = builder.nodeRole;
        this.labels = builder.labels;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String nodegroupName() {
        return this.nodegroupName;
    }

    public NodegroupScalingConfig scalingConfig() {
        return this.scalingConfig;
    }

    public Integer diskSize() {
        return this.diskSize;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public AMITypes amiType() {
        return AMITypes.fromValue(this.amiType);
    }

    public String amiTypeAsString() {
        return this.amiType;
    }

    public RemoteAccessConfig remoteAccess() {
        return this.remoteAccess;
    }

    public String nodeRole() {
        return this.nodeRole;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String version() {
        return this.version;
    }

    public String releaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodegroupRequest)) {
            return false;
        }
        CreateNodegroupRequest other = (CreateNodegroupRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.scalingConfig(), other.scalingConfig()) && Objects.equals(this.diskSize(), other.diskSize()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.amiTypeAsString(), other.amiTypeAsString()) && Objects.equals(this.remoteAccess(), other.remoteAccess()) && Objects.equals(this.nodeRole(), other.nodeRole()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releaseVersion(), other.releaseVersion());
    }

    public String toString() {
        return ToString.builder((String)"CreateNodegroupRequest").add("ClusterName", (Object)this.clusterName()).add("NodegroupName", (Object)this.nodegroupName()).add("ScalingConfig", (Object)this.scalingConfig()).add("DiskSize", (Object)this.diskSize()).add("Subnets", this.subnets()).add("InstanceTypes", this.instanceTypes()).add("AmiType", (Object)this.amiTypeAsString()).add("RemoteAccess", (Object)this.remoteAccess()).add("NodeRole", (Object)this.nodeRole()).add("Labels", this.labels()).add("Tags", this.tags()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Version", (Object)this.version()).add("ReleaseVersion", (Object)this.releaseVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "scalingConfig": {
                return Optional.ofNullable(clazz.cast(this.scalingConfig()));
            }
            case "diskSize": {
                return Optional.ofNullable(clazz.cast(this.diskSize()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "amiType": {
                return Optional.ofNullable(clazz.cast(this.amiTypeAsString()));
            }
            case "remoteAccess": {
                return Optional.ofNullable(clazz.cast(this.remoteAccess()));
            }
            case "nodeRole": {
                return Optional.ofNullable(clazz.cast(this.nodeRole()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releaseVersion": {
                return Optional.ofNullable(clazz.cast(this.releaseVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodegroupRequest, T> g) {
        return obj -> g.apply((CreateNodegroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodegroupName;
        private NodegroupScalingConfig scalingConfig;
        private Integer diskSize;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String amiType;
        private RemoteAccessConfig remoteAccess;
        private String nodeRole;
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientRequestToken;
        private String version;
        private String releaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodegroupRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodegroupName(model.nodegroupName);
            this.scalingConfig(model.scalingConfig);
            this.diskSize(model.diskSize);
            this.subnets(model.subnets);
            this.instanceTypes(model.instanceTypes);
            this.amiType(model.amiType);
            this.remoteAccess(model.remoteAccess);
            this.nodeRole(model.nodeRole);
            this.labels(model.labels);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
            this.version(model.version);
            this.releaseVersion(model.releaseVersion);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return this.scalingConfig != null ? this.scalingConfig.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        public final Integer getDiskSize() {
            return this.diskSize;
        }

        @Override
        public final Builder diskSize(Integer diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public final void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        public final String getAmiTypeAsString() {
            return this.amiType;
        }

        @Override
        public final Builder amiType(String amiType) {
            this.amiType = amiType;
            return this;
        }

        @Override
        public final Builder amiType(AMITypes amiType) {
            this.amiType(amiType == null ? null : amiType.toString());
            return this;
        }

        public final void setAmiType(String amiType) {
            this.amiType = amiType;
        }

        public final RemoteAccessConfig.Builder getRemoteAccess() {
            return this.remoteAccess != null ? this.remoteAccess.toBuilder() : null;
        }

        @Override
        public final Builder remoteAccess(RemoteAccessConfig remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public final void setRemoteAccess(RemoteAccessConfig.BuilderImpl remoteAccess) {
            this.remoteAccess = remoteAccess != null ? remoteAccess.build() : null;
        }

        public final String getNodeRole() {
            return this.nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        public final Map<String, String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodegroupRequest build() {
            return new CreateNodegroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNodegroupRequest> {
        public Builder clusterName(String var1);

        public Builder nodegroupName(String var1);

        public Builder scalingConfig(NodegroupScalingConfig var1);

        default public Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return this.scalingConfig((NodegroupScalingConfig)((NodegroupScalingConfig.Builder)NodegroupScalingConfig.builder().applyMutation(scalingConfig)).build());
        }

        public Builder diskSize(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder amiType(String var1);

        public Builder amiType(AMITypes var1);

        public Builder remoteAccess(RemoteAccessConfig var1);

        default public Builder remoteAccess(Consumer<RemoteAccessConfig.Builder> remoteAccess) {
            return this.remoteAccess((RemoteAccessConfig)((RemoteAccessConfig.Builder)RemoteAccessConfig.builder().applyMutation(remoteAccess)).build());
        }

        public Builder nodeRole(String var1);

        public Builder labels(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientRequestToken(String var1);

        public Builder version(String var1);

        public Builder releaseVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

