/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.FargateProfileLabelCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FargateProfileSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FargateProfileSelector> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FargateProfileSelector.getter(FargateProfileSelector::namespace)).setter(FargateProfileSelector.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(FargateProfileSelector.getter(FargateProfileSelector::labels)).setter(FargateProfileSelector.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, LABELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final Map<String, String> labels;

    private FargateProfileSelector(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.labels = builder.labels;
    }

    public String namespace() {
        return this.namespace;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateProfileSelector)) {
            return false;
        }
        FargateProfileSelector other = (FargateProfileSelector)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.labels(), other.labels());
    }

    public String toString() {
        return ToString.builder((String)"FargateProfileSelector").add("Namespace", (Object)this.namespace()).add("Labels", this.labels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FargateProfileSelector, T> g) {
        return obj -> g.apply((FargateProfileSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FargateProfileSelector model) {
            this.namespace(model.namespace);
            this.labels(model.labels);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Map<String, String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = FargateProfileLabelCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = FargateProfileLabelCopier.copy(labels);
        }

        public FargateProfileSelector build() {
            return new FargateProfileSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FargateProfileSelector> {
        public Builder namespace(String var1);

        public Builder labels(Map<String, String> var1);
    }
}

