/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.eks.DefaultEksClientBuilder;
import software.amazon.awssdk.services.eks.EksClientBuilder;
import software.amazon.awssdk.services.eks.model.BadRequestException;
import software.amazon.awssdk.services.eks.model.ClientException;
import software.amazon.awssdk.services.eks.model.CreateClusterRequest;
import software.amazon.awssdk.services.eks.model.CreateClusterResponse;
import software.amazon.awssdk.services.eks.model.DeleteClusterRequest;
import software.amazon.awssdk.services.eks.model.DeleteClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeUpdateRequest;
import software.amazon.awssdk.services.eks.model.DescribeUpdateResponse;
import software.amazon.awssdk.services.eks.model.EksException;
import software.amazon.awssdk.services.eks.model.InvalidParameterException;
import software.amazon.awssdk.services.eks.model.InvalidRequestException;
import software.amazon.awssdk.services.eks.model.ListClustersRequest;
import software.amazon.awssdk.services.eks.model.ListClustersResponse;
import software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.eks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.eks.model.ListUpdatesRequest;
import software.amazon.awssdk.services.eks.model.ListUpdatesResponse;
import software.amazon.awssdk.services.eks.model.NotFoundException;
import software.amazon.awssdk.services.eks.model.ResourceInUseException;
import software.amazon.awssdk.services.eks.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.eks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eks.model.ServerException;
import software.amazon.awssdk.services.eks.model.ServiceUnavailableException;
import software.amazon.awssdk.services.eks.model.TagResourceRequest;
import software.amazon.awssdk.services.eks.model.TagResourceResponse;
import software.amazon.awssdk.services.eks.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.eks.model.UntagResourceRequest;
import software.amazon.awssdk.services.eks.model.UntagResourceResponse;
import software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest;
import software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse;
import software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest;
import software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse;
import software.amazon.awssdk.services.eks.paginators.ListClustersIterable;
import software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable;

public interface EksClient
extends SdkClient {
    public static final String SERVICE_NAME = "eks";

    public static EksClient create() {
        return (EksClient)EksClient.builder().build();
    }

    public static EksClientBuilder builder() {
        return new DefaultEksClientBuilder();
    }

    default public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ResourceInUseException, ResourceLimitExceededException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) throws ResourceInUseException, ResourceLimitExceededException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        return this.createCluster((CreateClusterRequest)((Object)((CreateClusterRequest.Builder)CreateClusterRequest.builder().applyMutation(createClusterRequest)).build()));
    }

    default public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ResourceInUseException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) throws ResourceInUseException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.deleteCluster((DeleteClusterRequest)((Object)((DeleteClusterRequest.Builder)DeleteClusterRequest.builder().applyMutation(deleteClusterRequest)).build()));
    }

    default public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.describeCluster((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()));
    }

    default public DescribeUpdateResponse describeUpdate(DescribeUpdateRequest describeUpdateRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public DescribeUpdateResponse describeUpdate(Consumer<DescribeUpdateRequest.Builder> describeUpdateRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return this.describeUpdate((DescribeUpdateRequest)((Object)((DescribeUpdateRequest.Builder)DescribeUpdateRequest.builder().applyMutation(describeUpdateRequest)).build()));
    }

    default public ListClustersResponse listClusters() throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.listClusters((ListClustersRequest)((Object)ListClustersRequest.builder().build()));
    }

    default public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.listClusters((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    default public ListClustersIterable listClustersPaginator() throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.listClustersPaginator((ListClustersRequest)((Object)ListClustersRequest.builder().build()));
    }

    default public ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.listClustersPaginator((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListUpdatesResponse listUpdates(ListUpdatesRequest listUpdatesRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public ListUpdatesResponse listUpdates(Consumer<ListUpdatesRequest.Builder> listUpdatesRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return this.listUpdates((ListUpdatesRequest)((Object)((ListUpdatesRequest.Builder)ListUpdatesRequest.builder().applyMutation(listUpdatesRequest)).build()));
    }

    default public ListUpdatesIterable listUpdatesPaginator(ListUpdatesRequest listUpdatesRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public ListUpdatesIterable listUpdatesPaginator(Consumer<ListUpdatesRequest.Builder> listUpdatesRequest) throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return this.listUpdatesPaginator((ListUpdatesRequest)((Object)((ListUpdatesRequest.Builder)ListUpdatesRequest.builder().applyMutation(listUpdatesRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateClusterConfigResponse updateClusterConfig(UpdateClusterConfigRequest updateClusterConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public UpdateClusterConfigResponse updateClusterConfig(Consumer<UpdateClusterConfigRequest.Builder> updateClusterConfigRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        return this.updateClusterConfig((UpdateClusterConfigRequest)((Object)((UpdateClusterConfigRequest.Builder)UpdateClusterConfigRequest.builder().applyMutation(updateClusterConfigRequest)).build()));
    }

    default public UpdateClusterVersionResponse updateClusterVersion(UpdateClusterVersionRequest updateClusterVersionRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public UpdateClusterVersionResponse updateClusterVersion(Consumer<UpdateClusterVersionRequest.Builder> updateClusterVersionRequest) throws InvalidParameterException, ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        return this.updateClusterVersion((UpdateClusterVersionRequest)((Object)((UpdateClusterVersionRequest.Builder)UpdateClusterVersionRequest.builder().applyMutation(updateClusterVersionRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

