/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.TransitionToIARules;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicy> {
    private static final SdkField<String> TRANSITION_TO_IA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecyclePolicy.getter(LifecyclePolicy::transitionToIAAsString)).setter(LifecyclePolicy.setter(Builder::transitionToIA)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitionToIA").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSITION_TO_IA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitionToIA;

    private LifecyclePolicy(BuilderImpl builder) {
        this.transitionToIA = builder.transitionToIA;
    }

    public TransitionToIARules transitionToIA() {
        return TransitionToIARules.fromValue(this.transitionToIA);
    }

    public String transitionToIAAsString() {
        return this.transitionToIA;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitionToIAAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy)obj;
        return Objects.equals(this.transitionToIAAsString(), other.transitionToIAAsString());
    }

    public String toString() {
        return ToString.builder((String)"LifecyclePolicy").add("TransitionToIA", (Object)this.transitionToIAAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitionToIA": {
                return Optional.ofNullable(clazz.cast(this.transitionToIAAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitionToIA;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            this.transitionToIA(model.transitionToIA);
        }

        public final String getTransitionToIAAsString() {
            return this.transitionToIA;
        }

        @Override
        public final Builder transitionToIA(String transitionToIA) {
            this.transitionToIA = transitionToIA;
            return this;
        }

        @Override
        public final Builder transitionToIA(TransitionToIARules transitionToIA) {
            this.transitionToIA(transitionToIA.toString());
            return this;
        }

        public final void setTransitionToIA(String transitionToIA) {
            this.transitionToIA = transitionToIA;
        }

        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicy> {
        public Builder transitionToIA(String var1);

        public Builder transitionToIA(TransitionToIARules var1);
    }
}

