/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.DestinationToCreate;
import software.amazon.awssdk.services.efs.model.DestinationsToCreateCopier;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationConfigurationRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, CreateReplicationConfigurationRequest> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemId").getter(CreateReplicationConfigurationRequest.getter(CreateReplicationConfigurationRequest::sourceFileSystemId)).setter(CreateReplicationConfigurationRequest.setter(Builder::sourceFileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceFileSystemId").build()}).build();
    private static final SdkField<List<DestinationToCreate>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(CreateReplicationConfigurationRequest.getter(CreateReplicationConfigurationRequest::destinations)).setter(CreateReplicationConfigurationRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationToCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD, DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReplicationConfigurationRequest.memberNameToFieldInitializer();
    private final String sourceFileSystemId;
    private final List<DestinationToCreate> destinations;

    private CreateReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFileSystemId = builder.sourceFileSystemId;
        this.destinations = builder.destinations;
    }

    public final String sourceFileSystemId() {
        return this.sourceFileSystemId;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<DestinationToCreate> destinations() {
        return this.destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigurationRequest)) {
            return false;
        }
        CreateReplicationConfigurationRequest other = (CreateReplicationConfigurationRequest)((Object)obj);
        return Objects.equals(this.sourceFileSystemId(), other.sourceFileSystemId()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplicationConfigurationRequest").add("SourceFileSystemId", (Object)this.sourceFileSystemId()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceFileSystemId": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemId()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceFileSystemId", SOURCE_FILE_SYSTEM_ID_FIELD);
        map.put("Destinations", DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((CreateReplicationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String sourceFileSystemId;
        private List<DestinationToCreate> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigurationRequest model) {
            super(model);
            this.sourceFileSystemId(model.sourceFileSystemId);
            this.destinations(model.destinations);
        }

        public final String getSourceFileSystemId() {
            return this.sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        public final List<DestinationToCreate.Builder> getDestinations() {
            List<DestinationToCreate.Builder> result = DestinationsToCreateCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<DestinationToCreate.BuilderImpl> destinations) {
            this.destinations = DestinationsToCreateCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<DestinationToCreate> destinations) {
            this.destinations = DestinationsToCreateCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationToCreate ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<DestinationToCreate.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (DestinationToCreate)((DestinationToCreate.Builder)DestinationToCreate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationConfigurationRequest build() {
            return new CreateReplicationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationConfigurationRequest> {
        public Builder sourceFileSystemId(String var1);

        public Builder destinations(Collection<DestinationToCreate> var1);

        public Builder destinations(DestinationToCreate ... var1);

        public Builder destinations(Consumer<DestinationToCreate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

