/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceIdType {
    LONG_ID("LONG_ID"),
    SHORT_ID("SHORT_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceIdType> VALUE_MAP;
    private final String value;

    private ResourceIdType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceIdType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceIdType> knownValues() {
        EnumSet<ResourceIdType> knownValues = EnumSet.allOf(ResourceIdType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceIdType.class, ResourceIdType::toString);
    }
}

