/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccessPointsRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, DescribeAccessPointsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeAccessPointsRequest.getter(DescribeAccessPointsRequest::maxResults)).setter(DescribeAccessPointsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAccessPointsRequest.getter(DescribeAccessPointsRequest::nextToken)).setter(DescribeAccessPointsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointId").getter(DescribeAccessPointsRequest.getter(DescribeAccessPointsRequest::accessPointId)).setter(DescribeAccessPointsRequest.setter(Builder::accessPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccessPointId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DescribeAccessPointsRequest.getter(DescribeAccessPointsRequest::fileSystemId)).setter(DescribeAccessPointsRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FileSystemId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ACCESS_POINT_ID_FIELD, FILE_SYSTEM_ID_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final String accessPointId;
    private final String fileSystemId;

    private DescribeAccessPointsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.accessPointId = builder.accessPointId;
        this.fileSystemId = builder.fileSystemId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String accessPointId() {
        return this.accessPointId;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessPointsRequest)) {
            return false;
        }
        DescribeAccessPointsRequest other = (DescribeAccessPointsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.accessPointId(), other.accessPointId()) && Objects.equals(this.fileSystemId(), other.fileSystemId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccessPointsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("AccessPointId", (Object)this.accessPointId()).add("FileSystemId", (Object)this.fileSystemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AccessPointId": {
                return Optional.ofNullable(clazz.cast(this.accessPointId()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessPointsRequest, T> g) {
        return obj -> g.apply((DescribeAccessPointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String accessPointId;
        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessPointsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.accessPointId(model.accessPointId);
            this.fileSystemId(model.fileSystemId);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getAccessPointId() {
            return this.accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccessPointsRequest build() {
            return new DescribeAccessPointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccessPointsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder accessPointId(String var1);

        public Builder fileSystemId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

