/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Secret;

final class SecretListCopier {
    SecretListCopier() {
    }

    static List<Secret> copy(Collection<? extends Secret> secretListParam) {
        Object list;
        if (secretListParam == null || secretListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(secretListParam.size());
            secretListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Secret> copyFromBuilder(Collection<? extends Secret.Builder> secretListParam) {
        Object list;
        if (secretListParam == null || secretListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(secretListParam.size());
            secretListParam.forEach(entry -> {
                Secret member = entry == null ? null : (Secret)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Secret.Builder> copyToBuilder(Collection<? extends Secret> secretListParam) {
        Object list;
        if (secretListParam == null || secretListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(secretListParam.size());
            secretListParam.forEach(entry -> {
                Secret.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

