/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnvironmentFileType {
    S3("s3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnvironmentFileType> VALUE_MAP;
    private final String value;

    private EnvironmentFileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentFileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentFileType> knownValues() {
        EnumSet<EnvironmentFileType> knownValues = EnumSet.allOf(EnvironmentFileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnvironmentFileType.class, EnvironmentFileType::toString);
    }
}

