/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState;
import software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceHealthCheckResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceHealthCheckResult> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(InstanceHealthCheckResult.getter(InstanceHealthCheckResult::typeAsString)).setter(InstanceHealthCheckResult.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(InstanceHealthCheckResult.getter(InstanceHealthCheckResult::statusAsString)).setter(InstanceHealthCheckResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(InstanceHealthCheckResult.getter(InstanceHealthCheckResult::lastUpdated)).setter(InstanceHealthCheckResult.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusChange").getter(InstanceHealthCheckResult.getter(InstanceHealthCheckResult::lastStatusChange)).setter(InstanceHealthCheckResult.setter(Builder::lastStatusChange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD, LAST_UPDATED_FIELD, LAST_STATUS_CHANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceHealthCheckResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String status;
    private final Instant lastUpdated;
    private final Instant lastStatusChange;

    private InstanceHealthCheckResult(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.lastUpdated = builder.lastUpdated;
        this.lastStatusChange = builder.lastStatusChange;
    }

    public final InstanceHealthCheckType type() {
        return InstanceHealthCheckType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final InstanceHealthCheckState status() {
        return InstanceHealthCheckState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Instant lastStatusChange() {
        return this.lastStatusChange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHealthCheckResult)) {
            return false;
        }
        InstanceHealthCheckResult other = (InstanceHealthCheckResult)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.lastStatusChange(), other.lastStatusChange());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceHealthCheckResult").add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("LastUpdated", (Object)this.lastUpdated()).add("LastStatusChange", (Object)this.lastStatusChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "lastStatusChange": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdated", LAST_UPDATED_FIELD);
        map.put("lastStatusChange", LAST_STATUS_CHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceHealthCheckResult, T> g) {
        return obj -> g.apply((InstanceHealthCheckResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String status;
        private Instant lastUpdated;
        private Instant lastStatusChange;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHealthCheckResult model) {
            this.type(model.type);
            this.status(model.status);
            this.lastUpdated(model.lastUpdated);
            this.lastStatusChange(model.lastStatusChange);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InstanceHealthCheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceHealthCheckState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Instant getLastStatusChange() {
            return this.lastStatusChange;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public InstanceHealthCheckResult build() {
            return new InstanceHealthCheckResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceHealthCheckResult> {
        public Builder type(String var1);

        public Builder type(InstanceHealthCheckType var1);

        public Builder status(String var1);

        public Builder status(InstanceHealthCheckState var1);

        public Builder lastUpdated(Instant var1);

        public Builder lastStatusChange(Instant var1);
    }
}

