/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerInstanceStatus {
    ACTIVE("ACTIVE"),
    DRAINING("DRAINING"),
    REGISTERING("REGISTERING"),
    DEREGISTERING("DEREGISTERING"),
    REGISTRATION_FAILED("REGISTRATION_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerInstanceStatus> VALUE_MAP;
    private final String value;

    private ContainerInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerInstanceStatus> knownValues() {
        EnumSet<ContainerInstanceStatus> knownValues = EnumSet.allOf(ContainerInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerInstanceStatus.class, ContainerInstanceStatus::toString);
    }
}

