/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.InstanceRequirementsRequest;
import software.amazon.awssdk.services.ecs.model.ManagedInstancesMonitoringOptions;
import software.amazon.awssdk.services.ecs.model.ManagedInstancesNetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.ManagedInstancesStorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceLaunchTemplateUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceLaunchTemplateUpdate> {
    private static final SdkField<String> EC2_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2InstanceProfileArn").getter(InstanceLaunchTemplateUpdate.getter(InstanceLaunchTemplateUpdate::ec2InstanceProfileArn)).setter(InstanceLaunchTemplateUpdate.setter(Builder::ec2InstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceProfileArn").build()}).build();
    private static final SdkField<ManagedInstancesNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(InstanceLaunchTemplateUpdate.getter(InstanceLaunchTemplateUpdate::networkConfiguration)).setter(InstanceLaunchTemplateUpdate.setter(Builder::networkConfiguration)).constructor(ManagedInstancesNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<ManagedInstancesStorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageConfiguration").getter(InstanceLaunchTemplateUpdate.getter(InstanceLaunchTemplateUpdate::storageConfiguration)).setter(InstanceLaunchTemplateUpdate.setter(Builder::storageConfiguration)).constructor(ManagedInstancesStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build()}).build();
    private static final SdkField<String> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitoring").getter(InstanceLaunchTemplateUpdate.getter(InstanceLaunchTemplateUpdate::monitoringAsString)).setter(InstanceLaunchTemplateUpdate.setter(Builder::monitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoring").build()}).build();
    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceRequirements").getter(InstanceLaunchTemplateUpdate.getter(InstanceLaunchTemplateUpdate::instanceRequirements)).setter(InstanceLaunchTemplateUpdate.setter(Builder::instanceRequirements)).constructor(InstanceRequirementsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRequirements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_PROFILE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, STORAGE_CONFIGURATION_FIELD, MONITORING_FIELD, INSTANCE_REQUIREMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceLaunchTemplateUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ec2InstanceProfileArn;
    private final ManagedInstancesNetworkConfiguration networkConfiguration;
    private final ManagedInstancesStorageConfiguration storageConfiguration;
    private final String monitoring;
    private final InstanceRequirementsRequest instanceRequirements;

    private InstanceLaunchTemplateUpdate(BuilderImpl builder) {
        this.ec2InstanceProfileArn = builder.ec2InstanceProfileArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.storageConfiguration = builder.storageConfiguration;
        this.monitoring = builder.monitoring;
        this.instanceRequirements = builder.instanceRequirements;
    }

    public final String ec2InstanceProfileArn() {
        return this.ec2InstanceProfileArn;
    }

    public final ManagedInstancesNetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final ManagedInstancesStorageConfiguration storageConfiguration() {
        return this.storageConfiguration;
    }

    public final ManagedInstancesMonitoringOptions monitoring() {
        return ManagedInstancesMonitoringOptions.fromValue(this.monitoring);
    }

    public final String monitoringAsString() {
        return this.monitoring;
    }

    public final InstanceRequirementsRequest instanceRequirements() {
        return this.instanceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceLaunchTemplateUpdate)) {
            return false;
        }
        InstanceLaunchTemplateUpdate other = (InstanceLaunchTemplateUpdate)obj;
        return Objects.equals(this.ec2InstanceProfileArn(), other.ec2InstanceProfileArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.storageConfiguration(), other.storageConfiguration()) && Objects.equals(this.monitoringAsString(), other.monitoringAsString()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceLaunchTemplateUpdate").add("Ec2InstanceProfileArn", (Object)this.ec2InstanceProfileArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("StorageConfiguration", (Object)this.storageConfiguration()).add("Monitoring", (Object)this.monitoringAsString()).add("InstanceRequirements", (Object)this.instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2InstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceProfileArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "storageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageConfiguration()));
            }
            case "monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoringAsString()));
            }
            case "instanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ec2InstanceProfileArn", EC2_INSTANCE_PROFILE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("storageConfiguration", STORAGE_CONFIGURATION_FIELD);
        map.put("monitoring", MONITORING_FIELD);
        map.put("instanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceLaunchTemplateUpdate, T> g) {
        return obj -> g.apply((InstanceLaunchTemplateUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2InstanceProfileArn;
        private ManagedInstancesNetworkConfiguration networkConfiguration;
        private ManagedInstancesStorageConfiguration storageConfiguration;
        private String monitoring;
        private InstanceRequirementsRequest instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceLaunchTemplateUpdate model) {
            this.ec2InstanceProfileArn(model.ec2InstanceProfileArn);
            this.networkConfiguration(model.networkConfiguration);
            this.storageConfiguration(model.storageConfiguration);
            this.monitoring(model.monitoring);
            this.instanceRequirements(model.instanceRequirements);
        }

        public final String getEc2InstanceProfileArn() {
            return this.ec2InstanceProfileArn;
        }

        public final void setEc2InstanceProfileArn(String ec2InstanceProfileArn) {
            this.ec2InstanceProfileArn = ec2InstanceProfileArn;
        }

        @Override
        public final Builder ec2InstanceProfileArn(String ec2InstanceProfileArn) {
            this.ec2InstanceProfileArn = ec2InstanceProfileArn;
            return this;
        }

        public final ManagedInstancesNetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ManagedInstancesNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ManagedInstancesNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ManagedInstancesStorageConfiguration.Builder getStorageConfiguration() {
            return this.storageConfiguration != null ? this.storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(ManagedInstancesStorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(ManagedInstancesStorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final String getMonitoring() {
            return this.monitoring;
        }

        public final void setMonitoring(String monitoring) {
            this.monitoring = monitoring;
        }

        @Override
        public final Builder monitoring(String monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        @Override
        public final Builder monitoring(ManagedInstancesMonitoringOptions monitoring) {
            this.monitoring(monitoring == null ? null : monitoring.toString());
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public InstanceLaunchTemplateUpdate build() {
            return new InstanceLaunchTemplateUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceLaunchTemplateUpdate> {
        public Builder ec2InstanceProfileArn(String var1);

        public Builder networkConfiguration(ManagedInstancesNetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<ManagedInstancesNetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((ManagedInstancesNetworkConfiguration)((ManagedInstancesNetworkConfiguration.Builder)ManagedInstancesNetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder storageConfiguration(ManagedInstancesStorageConfiguration var1);

        default public Builder storageConfiguration(Consumer<ManagedInstancesStorageConfiguration.Builder> storageConfiguration) {
            return this.storageConfiguration((ManagedInstancesStorageConfiguration)((ManagedInstancesStorageConfiguration.Builder)ManagedInstancesStorageConfiguration.builder().applyMutation(storageConfiguration)).build());
        }

        public Builder monitoring(String var1);

        public Builder monitoring(ManagedInstancesMonitoringOptions var1);

        public Builder instanceRequirements(InstanceRequirementsRequest var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirementsRequest)((InstanceRequirementsRequest.Builder)InstanceRequirementsRequest.builder().applyMutation(instanceRequirements)).build());
        }
    }
}

