/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OSFamily {
    WINDOWS_SERVER_2019_FULL("WINDOWS_SERVER_2019_FULL"),
    WINDOWS_SERVER_2019_CORE("WINDOWS_SERVER_2019_CORE"),
    WINDOWS_SERVER_2016_FULL("WINDOWS_SERVER_2016_FULL"),
    WINDOWS_SERVER_2004_CORE("WINDOWS_SERVER_2004_CORE"),
    WINDOWS_SERVER_2022_CORE("WINDOWS_SERVER_2022_CORE"),
    WINDOWS_SERVER_2022_FULL("WINDOWS_SERVER_2022_FULL"),
    WINDOWS_SERVER_2025_CORE("WINDOWS_SERVER_2025_CORE"),
    WINDOWS_SERVER_2025_FULL("WINDOWS_SERVER_2025_FULL"),
    WINDOWS_SERVER_20_H2_CORE("WINDOWS_SERVER_20H2_CORE"),
    LINUX("LINUX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OSFamily> VALUE_MAP;
    private final String value;

    private OSFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OSFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OSFamily> knownValues() {
        EnumSet<OSFamily> knownValues = EnumSet.allOf(OSFamily.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OSFamily.class, OSFamily::toString);
    }
}

