/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentBrief;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentsBriefCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceDeploymentsResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListServiceDeploymentsResponse> {
    private static final SdkField<List<ServiceDeploymentBrief>> SERVICE_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceDeployments").getter(ListServiceDeploymentsResponse.getter(ListServiceDeploymentsResponse::serviceDeployments)).setter(ListServiceDeploymentsResponse.setter(Builder::serviceDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceDeploymentBrief::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServiceDeploymentsResponse.getter(ListServiceDeploymentsResponse::nextToken)).setter(ListServiceDeploymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceDeploymentsResponse.memberNameToFieldInitializer();
    private final List<ServiceDeploymentBrief> serviceDeployments;
    private final String nextToken;

    private ListServiceDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceDeployments = builder.serviceDeployments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceDeployments() {
        return this.serviceDeployments != null && !(this.serviceDeployments instanceof SdkAutoConstructList);
    }

    public final List<ServiceDeploymentBrief> serviceDeployments() {
        return this.serviceDeployments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceDeployments() ? this.serviceDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceDeploymentsResponse)) {
            return false;
        }
        ListServiceDeploymentsResponse other = (ListServiceDeploymentsResponse)((Object)obj);
        return this.hasServiceDeployments() == other.hasServiceDeployments() && Objects.equals(this.serviceDeployments(), other.serviceDeployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceDeploymentsResponse").add("ServiceDeployments", this.hasServiceDeployments() ? this.serviceDeployments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceDeployments": {
                return Optional.ofNullable(clazz.cast(this.serviceDeployments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceDeployments", SERVICE_DEPLOYMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceDeploymentsResponse, T> g) {
        return obj -> g.apply((ListServiceDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<ServiceDeploymentBrief> serviceDeployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceDeploymentsResponse model) {
            super(model);
            this.serviceDeployments(model.serviceDeployments);
            this.nextToken(model.nextToken);
        }

        public final List<ServiceDeploymentBrief.Builder> getServiceDeployments() {
            List<ServiceDeploymentBrief.Builder> result = ServiceDeploymentsBriefCopier.copyToBuilder(this.serviceDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDeployments(Collection<ServiceDeploymentBrief.BuilderImpl> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsBriefCopier.copyFromBuilder(serviceDeployments);
        }

        @Override
        public final Builder serviceDeployments(Collection<ServiceDeploymentBrief> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsBriefCopier.copy(serviceDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(ServiceDeploymentBrief ... serviceDeployments) {
            this.serviceDeployments(Arrays.asList(serviceDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(Consumer<ServiceDeploymentBrief.Builder> ... serviceDeployments) {
            this.serviceDeployments(Stream.of(serviceDeployments).map(c -> (ServiceDeploymentBrief)((ServiceDeploymentBrief.Builder)ServiceDeploymentBrief.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceDeploymentsResponse build() {
            return new ListServiceDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceDeploymentsResponse> {
        public Builder serviceDeployments(Collection<ServiceDeploymentBrief> var1);

        public Builder serviceDeployments(ServiceDeploymentBrief ... var1);

        public Builder serviceDeployments(Consumer<ServiceDeploymentBrief.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

