/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Connectivity {
    CONNECTED("CONNECTED"),
    DISCONNECTED("DISCONNECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Connectivity> VALUE_MAP;
    private final String value;

    private Connectivity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Connectivity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Connectivity> knownValues() {
        EnumSet<Connectivity> knownValues = EnumSet.allOf(Connectivity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Connectivity.class, Connectivity::toString);
    }
}

