/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.DescribeServicesRequest;
import software.amazon.awssdk.services.ecs.model.DescribeServicesResponse;
import software.amazon.awssdk.services.ecs.model.DescribeTasksRequest;
import software.amazon.awssdk.services.ecs.model.DescribeTasksResponse;
import software.amazon.awssdk.services.ecs.waiters.DefaultEcsAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface EcsAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesInactive(DescribeServicesRequest describeServicesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesInactive(Consumer<DescribeServicesRequest.Builder> describeServicesRequest) {
        return this.waitUntilServicesInactive((DescribeServicesRequest)((Object)((DescribeServicesRequest.Builder)DescribeServicesRequest.builder().applyMutation(describeServicesRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesInactive(DescribeServicesRequest describeServicesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesInactive(Consumer<DescribeServicesRequest.Builder> describeServicesRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilServicesInactive((DescribeServicesRequest)((Object)((DescribeServicesRequest.Builder)DescribeServicesRequest.builder().applyMutation(describeServicesRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesStable(DescribeServicesRequest describeServicesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesStable(Consumer<DescribeServicesRequest.Builder> describeServicesRequest) {
        return this.waitUntilServicesStable((DescribeServicesRequest)((Object)((DescribeServicesRequest.Builder)DescribeServicesRequest.builder().applyMutation(describeServicesRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesStable(DescribeServicesRequest describeServicesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServicesResponse>> waitUntilServicesStable(Consumer<DescribeServicesRequest.Builder> describeServicesRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilServicesStable((DescribeServicesRequest)((Object)((DescribeServicesRequest.Builder)DescribeServicesRequest.builder().applyMutation(describeServicesRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksRunning(DescribeTasksRequest describeTasksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksRunning(Consumer<DescribeTasksRequest.Builder> describeTasksRequest) {
        return this.waitUntilTasksRunning((DescribeTasksRequest)((Object)((DescribeTasksRequest.Builder)DescribeTasksRequest.builder().applyMutation(describeTasksRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksRunning(DescribeTasksRequest describeTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksRunning(Consumer<DescribeTasksRequest.Builder> describeTasksRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTasksRunning((DescribeTasksRequest)((Object)((DescribeTasksRequest.Builder)DescribeTasksRequest.builder().applyMutation(describeTasksRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksStopped(DescribeTasksRequest describeTasksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksStopped(Consumer<DescribeTasksRequest.Builder> describeTasksRequest) {
        return this.waitUntilTasksStopped((DescribeTasksRequest)((Object)((DescribeTasksRequest.Builder)DescribeTasksRequest.builder().applyMutation(describeTasksRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksStopped(DescribeTasksRequest describeTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTasksResponse>> waitUntilTasksStopped(Consumer<DescribeTasksRequest.Builder> describeTasksRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTasksStopped((DescribeTasksRequest)((Object)((DescribeTasksRequest.Builder)DescribeTasksRequest.builder().applyMutation(describeTasksRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultEcsAsyncWaiter.builder();
    }

    public static EcsAsyncWaiter create() {
        return DefaultEcsAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(EcsAsyncClient var1);

        public EcsAsyncWaiter build();
    }
}

