/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The key that encrypts and decrypts your resources for Service Connect TLS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectTlsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectTlsConfiguration.Builder, ServiceConnectTlsConfiguration> {
    private static final SdkField<ServiceConnectTlsCertificateAuthority> ISSUER_CERTIFICATE_AUTHORITY_FIELD = SdkField
            .<ServiceConnectTlsCertificateAuthority> builder(MarshallingType.SDK_POJO)
            .memberName("issuerCertificateAuthority")
            .getter(getter(ServiceConnectTlsConfiguration::issuerCertificateAuthority))
            .setter(setter(Builder::issuerCertificateAuthority))
            .constructor(ServiceConnectTlsCertificateAuthority::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateAuthority").build())
            .build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsKey")
            .getter(getter(ServiceConnectTlsConfiguration::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ServiceConnectTlsConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ISSUER_CERTIFICATE_AUTHORITY_FIELD, KMS_KEY_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceConnectTlsCertificateAuthority issuerCertificateAuthority;

    private final String kmsKey;

    private final String roleArn;

    private ServiceConnectTlsConfiguration(BuilderImpl builder) {
        this.issuerCertificateAuthority = builder.issuerCertificateAuthority;
        this.kmsKey = builder.kmsKey;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The signer certificate authority.
     * </p>
     * 
     * @return The signer certificate authority.
     */
    public final ServiceConnectTlsCertificateAuthority issuerCertificateAuthority() {
        return issuerCertificateAuthority;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service key.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service key.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuerCertificateAuthority());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectTlsConfiguration)) {
            return false;
        }
        ServiceConnectTlsConfiguration other = (ServiceConnectTlsConfiguration) obj;
        return Objects.equals(issuerCertificateAuthority(), other.issuerCertificateAuthority())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectTlsConfiguration").add("IssuerCertificateAuthority", issuerCertificateAuthority())
                .add("KmsKey", kmsKey()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issuerCertificateAuthority":
            return Optional.ofNullable(clazz.cast(issuerCertificateAuthority()));
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("issuerCertificateAuthority", ISSUER_CERTIFICATE_AUTHORITY_FIELD);
        map.put("kmsKey", KMS_KEY_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectTlsConfiguration, T> g) {
        return obj -> g.apply((ServiceConnectTlsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectTlsConfiguration> {
        /**
         * <p>
         * The signer certificate authority.
         * </p>
         * 
         * @param issuerCertificateAuthority
         *        The signer certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority issuerCertificateAuthority);

        /**
         * <p>
         * The signer certificate authority.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceConnectTlsCertificateAuthority.Builder} avoiding the need to create one manually via
         * {@link ServiceConnectTlsCertificateAuthority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectTlsCertificateAuthority.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority)}.
         * 
         * @param issuerCertificateAuthority
         *        a consumer that will call methods on {@link ServiceConnectTlsCertificateAuthority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority)
         */
        default Builder issuerCertificateAuthority(
                Consumer<ServiceConnectTlsCertificateAuthority.Builder> issuerCertificateAuthority) {
            return issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority.builder()
                    .applyMutation(issuerCertificateAuthority).build());
        }

        /**
         * <p>
         * The Amazon Web Services Key Management Service key.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Web Services Key Management Service key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private ServiceConnectTlsCertificateAuthority issuerCertificateAuthority;

        private String kmsKey;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectTlsConfiguration model) {
            issuerCertificateAuthority(model.issuerCertificateAuthority);
            kmsKey(model.kmsKey);
            roleArn(model.roleArn);
        }

        public final ServiceConnectTlsCertificateAuthority.Builder getIssuerCertificateAuthority() {
            return issuerCertificateAuthority != null ? issuerCertificateAuthority.toBuilder() : null;
        }

        public final void setIssuerCertificateAuthority(
                ServiceConnectTlsCertificateAuthority.BuilderImpl issuerCertificateAuthority) {
            this.issuerCertificateAuthority = issuerCertificateAuthority != null ? issuerCertificateAuthority.build() : null;
        }

        @Override
        public final Builder issuerCertificateAuthority(ServiceConnectTlsCertificateAuthority issuerCertificateAuthority) {
            this.issuerCertificateAuthority = issuerCertificateAuthority;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public ServiceConnectTlsConfiguration build() {
            return new ServiceConnectTlsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
