/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resolved configuration for a service revision, which contains the actual resources your service revision uses,
 * such as which target groups serve traffic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolvedConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolvedConfiguration.Builder, ResolvedConfiguration> {
    private static final SdkField<List<ServiceRevisionLoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<ServiceRevisionLoadBalancer>> builder(MarshallingType.LIST)
            .memberName("loadBalancers")
            .getter(getter(ResolvedConfiguration::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRevisionLoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRevisionLoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ServiceRevisionLoadBalancer> loadBalancers;

    private ResolvedConfiguration(BuilderImpl builder) {
        this.loadBalancers = builder.loadBalancers;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resolved load balancer configuration for the service revision. This includes information about which target
     * groups serve traffic and which listener rules direct traffic to them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return The resolved load balancer configuration for the service revision. This includes information about which
     *         target groups serve traffic and which listener rules direct traffic to them.
     */
    public final List<ServiceRevisionLoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedConfiguration)) {
            return false;
        }
        ResolvedConfiguration other = (ResolvedConfiguration) obj;
        return hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(loadBalancers(), other.loadBalancers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolvedConfiguration").add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("loadBalancers", LOAD_BALANCERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolvedConfiguration, T> g) {
        return obj -> g.apply((ResolvedConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolvedConfiguration> {
        /**
         * <p>
         * The resolved load balancer configuration for the service revision. This includes information about which
         * target groups serve traffic and which listener rules direct traffic to them.
         * </p>
         * 
         * @param loadBalancers
         *        The resolved load balancer configuration for the service revision. This includes information about
         *        which target groups serve traffic and which listener rules direct traffic to them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<ServiceRevisionLoadBalancer> loadBalancers);

        /**
         * <p>
         * The resolved load balancer configuration for the service revision. This includes information about which
         * target groups serve traffic and which listener rules direct traffic to them.
         * </p>
         * 
         * @param loadBalancers
         *        The resolved load balancer configuration for the service revision. This includes information about
         *        which target groups serve traffic and which listener rules direct traffic to them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(ServiceRevisionLoadBalancer... loadBalancers);

        /**
         * <p>
         * The resolved load balancer configuration for the service revision. This includes information about which
         * target groups serve traffic and which listener rules direct traffic to them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRevisionLoadBalancer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRevisionLoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRevisionLoadBalancer.Builder#build()} is called
         * immediately and its result is passed to {@link #loadBalancers(List<ServiceRevisionLoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceRevisionLoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<ServiceRevisionLoadBalancer>)
         */
        Builder loadBalancers(Consumer<ServiceRevisionLoadBalancer.Builder>... loadBalancers);
    }

    static final class BuilderImpl implements Builder {
        private List<ServiceRevisionLoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedConfiguration model) {
            loadBalancers(model.loadBalancers);
        }

        public final List<ServiceRevisionLoadBalancer.Builder> getLoadBalancers() {
            List<ServiceRevisionLoadBalancer.Builder> result = ServiceRevisionLoadBalancersCopier
                    .copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<ServiceRevisionLoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = ServiceRevisionLoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<ServiceRevisionLoadBalancer> loadBalancers) {
            this.loadBalancers = ServiceRevisionLoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(ServiceRevisionLoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<ServiceRevisionLoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> ServiceRevisionLoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResolvedConfiguration build() {
            return new ResolvedConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
