/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a volume mount point that's used in a container definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MountPoint implements SdkPojo, Serializable, ToCopyableBuilder<MountPoint.Builder, MountPoint> {
    private static final SdkField<String> SOURCE_VOLUME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVolume").getter(getter(MountPoint::sourceVolume)).setter(setter(Builder::sourceVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVolume").build()).build();

    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerPath").getter(getter(MountPoint::containerPath)).setter(setter(Builder::containerPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPath").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readOnly").getter(getter(MountPoint::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VOLUME_FIELD,
            CONTAINER_PATH_FIELD, READ_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceVolume;

    private final String containerPath;

    private final Boolean readOnly;

    private MountPoint(BuilderImpl builder) {
        this.sourceVolume = builder.sourceVolume;
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
    }

    /**
     * <p>
     * The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of task
     * definition <code>volume</code>.
     * </p>
     * 
     * @return The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of
     *         task definition <code>volume</code>.
     */
    public final String sourceVolume() {
        return sourceVolume;
    }

    /**
     * <p>
     * The path on the container to mount the host volume at.
     * </p>
     * 
     * @return The path on the container to mount the host volume at.
     */
    public final String containerPath() {
        return containerPath;
    }

    /**
     * <p>
     * If this value is <code>true</code>, the container has read-only access to the volume. If this value is
     * <code>false</code>, then the container can write to the volume. The default value is <code>false</code>.
     * </p>
     * 
     * @return If this value is <code>true</code>, the container has read-only access to the volume. If this value is
     *         <code>false</code>, then the container can write to the volume. The default value is <code>false</code>.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceVolume());
        hashCode = 31 * hashCode + Objects.hashCode(containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint) obj;
        return Objects.equals(sourceVolume(), other.sourceVolume()) && Objects.equals(containerPath(), other.containerPath())
                && Objects.equals(readOnly(), other.readOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MountPoint").add("SourceVolume", sourceVolume()).add("ContainerPath", containerPath())
                .add("ReadOnly", readOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceVolume":
            return Optional.ofNullable(clazz.cast(sourceVolume()));
        case "containerPath":
            return Optional.ofNullable(clazz.cast(containerPath()));
        case "readOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceVolume", SOURCE_VOLUME_FIELD);
        map.put("containerPath", CONTAINER_PATH_FIELD);
        map.put("readOnly", READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MountPoint, T> g) {
        return obj -> g.apply((MountPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MountPoint> {
        /**
         * <p>
         * The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of task
         * definition <code>volume</code>.
         * </p>
         * 
         * @param sourceVolume
         *        The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter
         *        of task definition <code>volume</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolume(String sourceVolume);

        /**
         * <p>
         * The path on the container to mount the host volume at.
         * </p>
         * 
         * @param containerPath
         *        The path on the container to mount the host volume at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);

        /**
         * <p>
         * If this value is <code>true</code>, the container has read-only access to the volume. If this value is
         * <code>false</code>, then the container can write to the volume. The default value is <code>false</code>.
         * </p>
         * 
         * @param readOnly
         *        If this value is <code>true</code>, the container has read-only access to the volume. If this value is
         *        <code>false</code>, then the container can write to the volume. The default value is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);
    }

    static final class BuilderImpl implements Builder {
        private String sourceVolume;

        private String containerPath;

        private Boolean readOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            sourceVolume(model.sourceVolume);
            containerPath(model.containerPath);
            readOnly(model.readOnly);
        }

        public final String getSourceVolume() {
            return sourceVolume;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final String getContainerPath() {
            return containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        public MountPoint build() {
            return new MountPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
